/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.internal.ClientCallImpl;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.SerializingExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

final class SingleTransportChannel
extends Channel {
    private final ClientTransport transport;
    private final Executor executor;
    private final String authority;
    private final ScheduledExecutorService deadlineCancellationExecutor;
    private final ClientCallImpl.ClientTransportProvider transportProvider = new ClientCallImpl.ClientTransportProvider(){

        @Override
        public ClientTransport get(CallOptions callOptions) {
            return SingleTransportChannel.this.transport;
        }
    };

    public SingleTransportChannel(ClientTransport transport, Executor executor, ScheduledExecutorService deadlineCancellationExecutor, String authority) {
        this.transport = (ClientTransport)Preconditions.checkNotNull((Object)transport, (Object)"transport");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.deadlineCancellationExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)deadlineCancellationExecutor, (Object)"deadlineCancellationExecutor");
        this.authority = (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
    }

    @Override
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return new ClientCallImpl<RequestT, ResponseT>(methodDescriptor, new SerializingExecutor(this.executor), callOptions, this.transportProvider, this.deadlineCancellationExecutor);
    }

    @Override
    public String authority() {
        return this.authority;
    }
}

