/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.util.Context;
import java.util.Arrays;
import java.util.Collection;

public class MultiTaskListener
implements TaskListener {
    public static final Context.Key<MultiTaskListener> taskListenerKey = new Context.Key();
    TaskListener[] listeners = new TaskListener[0];
    ClientCodeWrapper ccw;

    public static MultiTaskListener instance(Context context) {
        MultiTaskListener multiTaskListener = context.get(taskListenerKey);
        if (multiTaskListener == null) {
            multiTaskListener = new MultiTaskListener(context);
        }
        return multiTaskListener;
    }

    protected MultiTaskListener(Context context) {
        context.put(taskListenerKey, this);
        this.ccw = ClientCodeWrapper.instance(context);
    }

    public Collection<TaskListener> getTaskListeners() {
        return Arrays.asList(this.listeners);
    }

    public boolean isEmpty() {
        return this.listeners.length == 0;
    }

    public void add(TaskListener taskListener) {
        for (TaskListener taskListener2 : this.listeners) {
            if (this.ccw.unwrap(taskListener2) != taskListener) continue;
            throw new IllegalStateException();
        }
        this.listeners = Arrays.copyOf(this.listeners, this.listeners.length + 1);
        this.listeners[this.listeners.length - 1] = this.ccw.wrap(taskListener);
    }

    public void remove(TaskListener taskListener) {
        for (int i = 0; i < this.listeners.length; ++i) {
            if (this.ccw.unwrap(this.listeners[i]) != taskListener) continue;
            TaskListener[] taskListenerArray = new TaskListener[this.listeners.length - 1];
            System.arraycopy(this.listeners, 0, taskListenerArray, 0, i);
            System.arraycopy(this.listeners, i + 1, taskListenerArray, i, taskListenerArray.length - i);
            this.listeners = taskListenerArray;
            break;
        }
    }

    @Override
    public void started(TaskEvent taskEvent) {
        TaskListener[] taskListenerArray;
        for (TaskListener taskListener : taskListenerArray = this.listeners) {
            taskListener.started(taskEvent);
        }
    }

    @Override
    public void finished(TaskEvent taskEvent) {
        TaskListener[] taskListenerArray;
        for (TaskListener taskListener : taskListenerArray = this.listeners) {
            taskListener.finished(taskEvent);
        }
    }

    public String toString() {
        return Arrays.toString(this.listeners);
    }
}

