/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableBiMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(name="MutableConstantField", category=BugPattern.Category.JDK, summary="Constant field declarations should use the immutable type (such as ImmutableList) instead of the general collection interface type (such as List)", severity=BugPattern.SeverityLevel.WARNING)
public final class MutableConstantField
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final ImmutableBiMap<String, String> MUTABLE_TO_IMMUTABLE_CLASS_NAME_MAP = ImmutableBiMap.builder().put((Object)"com.google.common.collect.BiMap", (Object)"com.google.common.collect.ImmutableBiMap").put((Object)"com.google.common.collect.ListMultimap", (Object)"com.google.common.collect.ImmutableListMultimap").put((Object)"com.google.common.collect.RangeMap", (Object)"com.google.common.collect.ImmutableRangeMap").put((Object)"com.google.common.collect.RangeSet", (Object)"com.google.common.collect.ImmutableRangeSet").put((Object)"com.google.common.collect.SetMultimap", (Object)"com.google.common.collect.ImmutableSetMultimap").put((Object)"com.google.common.collect.SortedMultiset", (Object)"com.google.common.collect.ImmutableSortedMultiset").put((Object)"com.google.common.collect.Table", (Object)"com.google.common.collect.ImmutableTable").put((Object)"java.util.Collection", (Object)"com.google.common.collect.ImmutableCollection").put((Object)"java.util.List", (Object)"com.google.common.collect.ImmutableList").put((Object)"java.util.Map", (Object)"com.google.common.collect.ImmutableMap").put((Object)"java.util.Multimap", (Object)"com.google.common.collect.ImmutableMultimap").put((Object)"java.util.Multiset", (Object)"com.google.common.collect.ImmutableMultiset").put((Object)"java.util.NavigableMap", (Object)"com.google.common.collect.ImmutableSortedMap").put((Object)"java.util.NavigableSet", (Object)"com.google.common.collect.ImmutableSortedSet").put((Object)"java.util.Set", (Object)"com.google.common.collect.ImmutableSet").build();
    private static final SimpleTreeVisitor<Tree, Void> GET_TYPE_TREE_VISITOR = new SimpleTreeVisitor<Tree, Void>(){

        @Override
        public Tree visitIdentifier(IdentifierTree tree, Void unused) {
            return tree;
        }

        @Override
        public Tree visitParameterizedType(ParameterizedTypeTree tree, Void unused) {
            return tree.getType();
        }
    };

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (!MutableConstantField.isConstantField(ASTHelpers.getSymbol((VariableTree)tree))) {
            return Description.NO_MATCH;
        }
        ExpressionTree rhsTree = tree.getInitializer();
        Type rhsType = ASTHelpers.getType((Tree)rhsTree);
        if (rhsType == null || !MutableConstantField.isImmutableType(rhsType)) {
            return Description.NO_MATCH;
        }
        Tree lhsTree = tree.getType();
        Type lhsType = ASTHelpers.getType((Tree)lhsTree);
        if (lhsType == null || MutableConstantField.isImmutableType(lhsType)) {
            return Description.NO_MATCH;
        }
        String lhsTypeQualifiedName = MutableConstantField.getTypeQualifiedName(lhsType);
        String newLhsTypeQualifiedName = MUTABLE_TO_IMMUTABLE_CLASS_NAME_MAP.containsKey((Object)lhsTypeQualifiedName) ? (String)MUTABLE_TO_IMMUTABLE_CLASS_NAME_MAP.get((Object)lhsTypeQualifiedName) : MutableConstantField.getTypeQualifiedName(rhsType);
        Type newLhsType = state.getTypeFromString(newLhsTypeQualifiedName);
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        fixBuilder.replace(MutableConstantField.getTypeTree(lhsTree), SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fixBuilder, (Symbol.TypeSymbol)newLhsType.asElement()));
        SuggestedFix fix = fixBuilder.build();
        return this.describeMatch(lhsTree, (Fix)fix);
    }

    private static boolean isImmutableType(Type type) {
        return MUTABLE_TO_IMMUTABLE_CLASS_NAME_MAP.values().contains((Object)MutableConstantField.getTypeQualifiedName(type));
    }

    private static String getTypeQualifiedName(Type type) {
        return type.tsym.getQualifiedName().toString();
    }

    private static boolean isConstantField(Symbol sym) {
        return sym.getKind() == ElementKind.FIELD && MutableConstantField.isStaticFinalField(sym) && MutableConstantField.isConstantFieldName(sym.getSimpleName().toString());
    }

    private static boolean isStaticFinalField(Symbol sym) {
        return sym.isStatic() && sym.getModifiers().contains((Object)Modifier.FINAL);
    }

    private static boolean isConstantFieldName(String fieldName) {
        return fieldName.toUpperCase().equals(fieldName);
    }

    private static Tree getTypeTree(Tree tree) {
        return tree.accept(GET_TYPE_TREE_VISITOR, null);
    }
}

