/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import dagger.shaded.auto.common.MoreElements;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;

final class Accessibility {
    static boolean isTypeAccessibleFrom(TypeMirror type, String packageName) {
        return type.accept(new TypeAccessiblityVisitor(packageName), null);
    }

    static boolean isElementAccessibleFrom(Element element, String packageName) {
        return element.accept(new ElementAccessibilityVisitor(packageName), null);
    }

    static boolean isElementAccessibleFromOwnPackage(Element element) {
        return Accessibility.isElementAccessibleFrom(element, MoreElements.getPackage(element).getQualifiedName().toString());
    }

    private Accessibility() {
    }

    private static final class ElementAccessibilityVisitor
    extends SimpleElementVisitor6<Boolean, Void> {
        final String packageName;

        ElementAccessibilityVisitor(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public Boolean visitPackage(PackageElement element, Void p) {
            return true;
        }

        @Override
        public Boolean visitType(TypeElement element, Void p) {
            switch (element.getNestingKind()) {
                case MEMBER: {
                    return this.accessibleMember(element);
                }
                case TOP_LEVEL: {
                    return this.accessibleModifiers(element);
                }
                case ANONYMOUS: 
                case LOCAL: {
                    return false;
                }
            }
            throw new AssertionError();
        }

        boolean accessibleMember(Element element) {
            if (!element.getEnclosingElement().accept(this, null).booleanValue()) {
                return false;
            }
            return this.accessibleModifiers(element);
        }

        boolean accessibleModifiers(Element element) {
            if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                return true;
            }
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                return false;
            }
            return MoreElements.getPackage(element).getQualifiedName().contentEquals(this.packageName);
        }

        @Override
        public Boolean visitTypeParameter(TypeParameterElement element, Void p) {
            throw new IllegalArgumentException("It does not make sense to check the accessibility of a type parameter");
        }

        @Override
        public Boolean visitExecutable(ExecutableElement element, Void p) {
            return this.accessibleMember(element);
        }

        @Override
        public Boolean visitVariable(VariableElement element, Void p) {
            ElementKind kind = element.getKind();
            Preconditions.checkArgument((boolean)kind.isField(), (String)"checking a variable that isn't a field: %s", (Object[])new Object[]{kind});
            return this.accessibleMember(element);
        }
    }

    private static final class TypeAccessiblityVisitor
    extends SimpleTypeVisitor6<Boolean, Void> {
        final String packageName;

        TypeAccessiblityVisitor(String packageName) {
            this.packageName = packageName;
        }

        boolean isAccessible(TypeMirror type) {
            return type.accept(this, null);
        }

        @Override
        public Boolean visitNoType(NoType type, Void p) {
            return true;
        }

        @Override
        public Boolean visitDeclared(DeclaredType type, Void p) {
            if (!this.isAccessible(type.getEnclosingType())) {
                return false;
            }
            if (!Accessibility.isElementAccessibleFrom(type.asElement(), this.packageName)) {
                return false;
            }
            for (TypeMirror typeMirror : type.getTypeArguments()) {
                if (this.isAccessible(typeMirror)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitArray(ArrayType type, Void p) {
            return type.getComponentType().accept(this, null);
        }

        @Override
        public Boolean visitPrimitive(PrimitiveType type, Void p) {
            return true;
        }

        @Override
        public Boolean visitNull(NullType type, Void p) {
            return true;
        }

        @Override
        public Boolean visitTypeVariable(TypeVariable type, Void p) {
            return true;
        }

        @Override
        public Boolean visitWildcard(WildcardType type, Void p) {
            if (type.getExtendsBound() != null && !this.isAccessible(type.getExtendsBound())) {
                return false;
            }
            if (type.getSuperBound() != null && !this.isAccessible(type.getSuperBound())) {
                return false;
            }
            return true;
        }

        @Override
        protected Boolean defaultAction(TypeMirror type, Void p) {
            throw new IllegalArgumentException(String.format("%s of kind %s should not be checked for accessibility", new Object[]{type, type.getKind()}));
        }
    }
}

