/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.analysis;

import com.sun.source.tree.MethodInvocationTree;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.ExplicitThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.dataflow.cfg.node.SuperNode;
import org.checkerframework.dataflow.cfg.node.ThisLiteralNode;
import org.checkerframework.dataflow.cfg.node.ValueLiteralNode;
import org.checkerframework.dataflow.cfg.node.WideningConversionNode;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.dataflow.util.PurityUtils;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class FlowExpressions {
    public static FieldAccess internalReprOfFieldAccess(AnnotationProvider provider, FieldAccessNode node) {
        Node receiverNode = node.getReceiver();
        Receiver receiver = node.isStatic() ? new ClassName(receiverNode.getType()) : FlowExpressions.internalReprOf(provider, receiverNode);
        return new FieldAccess(receiver, node);
    }

    public static ArrayAccess internalReprOfArrayAccess(AnnotationProvider provider, ArrayAccessNode node) {
        Receiver receiver = FlowExpressions.internalReprOf(provider, node.getArray());
        Receiver index = FlowExpressions.internalReprOf(provider, node.getIndex());
        return new ArrayAccess(node.getType(), receiver, index);
    }

    public static Receiver internalReprOf(AnnotationProvider provider, Node receiverNode) {
        return FlowExpressions.internalReprOf(provider, receiverNode, false);
    }

    public static Receiver internalReprOf(AnnotationProvider provider, Node receiverNode, boolean allowNonDeterminitic) {
        Receiver receiver = null;
        if (receiverNode instanceof FieldAccessNode) {
            FieldAccessNode fan = (FieldAccessNode)receiverNode;
            receiver = fan.getFieldName().equals("this") ? new ThisReference(fan.getReceiver().getType()) : FlowExpressions.internalReprOfFieldAccess(provider, fan);
        } else if (receiverNode instanceof ExplicitThisLiteralNode) {
            receiver = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof ThisLiteralNode) {
            receiver = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof SuperNode) {
            receiver = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof LocalVariableNode) {
            LocalVariableNode lv = (LocalVariableNode)receiverNode;
            receiver = new LocalVariable(lv);
        } else if (receiverNode instanceof ArrayAccessNode) {
            ArrayAccessNode a = (ArrayAccessNode)receiverNode;
            receiver = FlowExpressions.internalReprOfArrayAccess(provider, a);
        } else {
            if (receiverNode instanceof StringConversionNode) {
                return FlowExpressions.internalReprOf(provider, ((StringConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof WideningConversionNode) {
                return FlowExpressions.internalReprOf(provider, ((WideningConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof NarrowingConversionNode) {
                return FlowExpressions.internalReprOf(provider, ((NarrowingConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof ClassNameNode) {
                ClassNameNode cn = (ClassNameNode)receiverNode;
                receiver = new ClassName(cn.getType());
            } else if (receiverNode instanceof ValueLiteralNode) {
                ValueLiteralNode vn = (ValueLiteralNode)receiverNode;
                receiver = new ValueLiteral(vn.getType(), vn);
            } else if (receiverNode instanceof MethodInvocationNode) {
                Node arg;
                MethodInvocationNode mn = (MethodInvocationNode)receiverNode;
                ExecutableElement invokedMethod = TreeUtils.elementFromUse((MethodInvocationTree)mn.getTree());
                boolean considerDeterministic = false;
                if (invokedMethod.toString().equals("valueOf(long)") && mn.getTarget().getReceiver().toString().equals("Long") && (arg = mn.getArgument(0)) instanceof ValueLiteralNode) {
                    considerDeterministic = true;
                }
                if (PurityUtils.isDeterministic(provider, invokedMethod) || allowNonDeterminitic || considerDeterministic) {
                    ArrayList<Receiver> parameters = new ArrayList<Receiver>();
                    for (Node p : mn.getArguments()) {
                        parameters.add(FlowExpressions.internalReprOf(provider, p));
                    }
                    Receiver methodReceiver = ElementUtils.isStatic((Element)invokedMethod) ? new ClassName(mn.getTarget().getReceiver().getType()) : FlowExpressions.internalReprOf(provider, mn.getTarget().getReceiver());
                    receiver = new PureMethodCall(mn.getType(), invokedMethod, methodReceiver, parameters);
                }
            }
        }
        if (receiver == null) {
            receiver = new Unknown(receiverNode.getType());
        }
        return receiver;
    }

    public static class ArrayAccess
    extends Receiver {
        protected final Receiver receiver;
        protected final Receiver index;

        public ArrayAccess(TypeMirror type, Receiver receiver, Receiver index) {
            super(type);
            this.receiver = receiver;
            this.index = index;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            if (this.getClass().equals(clazz)) {
                return true;
            }
            if (this.receiver.containsOfClass(clazz)) {
                return true;
            }
            return this.index.containsOfClass(clazz);
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public Receiver getIndex() {
            return this.index;
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return false;
        }

        @Override
        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other) || this.receiver.syntacticEquals(other) || this.index.syntacticEquals(other);
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            if (!(other instanceof ArrayAccess)) {
                return false;
            }
            ArrayAccess otherArrayAccess = (ArrayAccess)other;
            if (!this.receiver.syntacticEquals(otherArrayAccess.receiver)) {
                return false;
            }
            return this.index.syntacticEquals(otherArrayAccess.index);
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            if (this.receiver.containsModifiableAliasOf(store, other)) {
                return true;
            }
            return this.index.containsModifiableAliasOf(store, other);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ArrayAccess)) {
                return false;
            }
            ArrayAccess other = (ArrayAccess)obj;
            return this.receiver.equals(other.receiver) && this.index.equals(other.index);
        }

        public int hashCode() {
            return HashCodeUtils.hash(this.receiver, this.index);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.receiver.toString());
            result.append("[");
            result.append(this.index.toString());
            result.append("]");
            return result.toString();
        }
    }

    public static class PureMethodCall
    extends Receiver {
        protected final Receiver receiver;
        protected final List<Receiver> parameters;
        protected final Element method;

        public PureMethodCall(TypeMirror type, Element method, Receiver receiver, List<Receiver> parameters) {
            super(type);
            this.receiver = receiver;
            this.parameters = parameters;
            this.method = method;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            if (this.getClass().equals(clazz)) {
                return true;
            }
            if (this.receiver.containsOfClass(clazz)) {
                return true;
            }
            for (Receiver p : this.parameters) {
                if (!p.containsOfClass(clazz)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return false;
        }

        @Override
        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other) || this.receiver.syntacticEquals(other);
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            if (!(other instanceof PureMethodCall)) {
                return false;
            }
            PureMethodCall otherMethod = (PureMethodCall)other;
            if (!this.receiver.syntacticEquals(otherMethod.receiver)) {
                return false;
            }
            if (this.parameters.size() != otherMethod.parameters.size()) {
                return false;
            }
            int i = 0;
            for (Receiver p : this.parameters) {
                if (!p.syntacticEquals(otherMethod.parameters.get(i))) {
                    return false;
                }
                ++i;
            }
            return this.method.equals(otherMethod.method);
        }

        public boolean containsSyntacticEqualParameter(LocalVariable var) {
            for (Receiver p : this.parameters) {
                if (!p.containsSyntacticEqualReceiver(var)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            if (this.receiver.containsModifiableAliasOf(store, other)) {
                return true;
            }
            for (Receiver p : this.parameters) {
                if (!p.containsModifiableAliasOf(store, other)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof PureMethodCall)) {
                return false;
            }
            PureMethodCall other = (PureMethodCall)obj;
            int i = 0;
            for (Receiver p : this.parameters) {
                if (!p.equals(other.parameters.get(i))) {
                    return false;
                }
                ++i;
            }
            return this.receiver.equals(other.receiver) && this.method.equals(other.method);
        }

        public int hashCode() {
            int hash = HashCodeUtils.hash(this.method, this.receiver);
            for (Receiver p : this.parameters) {
                hash = HashCodeUtils.hash(hash, (Object)p);
            }
            return hash;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this.receiver.toString());
            result.append(".");
            String methodName = this.method.getSimpleName().toString();
            result.append(methodName);
            result.append("(");
            boolean first = true;
            for (Receiver p : this.parameters) {
                if (!first) {
                    result.append(", ");
                }
                result.append(p.toString());
                first = false;
            }
            result.append(")");
            return result.toString();
        }
    }

    public static class ValueLiteral
    extends Receiver {
        protected final Object value;

        public ValueLiteral(TypeMirror type, ValueLiteralNode node) {
            super(type);
            this.value = node.getValue();
        }

        public ValueLiteral(TypeMirror type, Object value) {
            super(type);
            this.value = value;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass().equals(clazz);
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return true;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ValueLiteral)) {
                return false;
            }
            ValueLiteral other = (ValueLiteral)obj;
            if (this.value == null) {
                return this.type.toString().equals(other.type.toString()) && other.value == null;
            }
            return this.type.toString().equals(other.type.toString()) && this.value.equals(other.value);
        }

        public String toString() {
            if (TypesUtils.isString((TypeMirror)this.type)) {
                return "\"" + this.value + "\"";
            }
            if (this.type.getKind() == TypeKind.LONG) {
                return this.value.toString() + "L";
            }
            return this.value == null ? "null" : this.value.toString();
        }

        public int hashCode() {
            return HashCodeUtils.hash(this.value, this.type.toString());
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            return this.equals(other);
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return false;
        }
    }

    public static class LocalVariable
    extends Receiver {
        protected Element element;

        public LocalVariable(LocalVariableNode localVar) {
            super(localVar.getType());
            this.element = localVar.getElement();
        }

        public LocalVariable(Element elem) {
            super(ElementUtils.getType((Element)elem));
            this.element = elem;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof LocalVariable)) {
                return false;
            }
            LocalVariable other = (LocalVariable)obj;
            return other.element.equals(this.element);
        }

        public Element getElement() {
            return this.element;
        }

        public int hashCode() {
            return HashCodeUtils.hash((Object)this.element);
        }

        public String toString() {
            return this.element.toString();
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass().equals(clazz);
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            if (!(other instanceof LocalVariable)) {
                return false;
            }
            LocalVariable l = (LocalVariable)other;
            return l.getElement().equals(this.getElement());
        }

        @Override
        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other);
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return true;
        }
    }

    public static class Unknown
    extends Receiver {
        public Unknown(TypeMirror type) {
            super(type);
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public String toString() {
            return "?";
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return true;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass().equals(clazz);
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return false;
        }
    }

    public static class ClassName
    extends Receiver {
        protected Element element;

        public ClassName(TypeMirror type) {
            super(type);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ClassName)) {
                return false;
            }
            ClassName other = (ClassName)obj;
            return this.getType().toString().equals(other.getType().toString());
        }

        public int hashCode() {
            return HashCodeUtils.hash((Object)this.getType().toString());
        }

        public String toString() {
            return this.getType().toString();
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass().equals(clazz);
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            return this.equals(other);
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return true;
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return false;
        }
    }

    public static class ThisReference
    extends Receiver {
        public ThisReference(TypeMirror type) {
            super(type);
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof ThisReference;
        }

        public int hashCode() {
            return HashCodeUtils.hash(0);
        }

        public String toString() {
            return "this";
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass().equals(clazz);
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            return other instanceof ThisReference;
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return true;
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return false;
        }
    }

    public static class FieldAccess
    extends Receiver {
        protected Receiver receiver;
        protected VariableElement field;

        public Receiver getReceiver() {
            return this.receiver;
        }

        public VariableElement getField() {
            return this.field;
        }

        public FieldAccess(Receiver receiver, FieldAccessNode node) {
            super(node.getType());
            this.receiver = receiver;
            this.field = node.getElement();
        }

        public FieldAccess(Receiver receiver, TypeMirror type, VariableElement fieldElement) {
            super(type);
            this.receiver = receiver;
            this.field = fieldElement;
        }

        public boolean isFinal() {
            return ElementUtils.isFinal((Element)this.field);
        }

        public boolean isStatic() {
            return ElementUtils.isStatic((Element)this.field);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof FieldAccess)) {
                return false;
            }
            FieldAccess fa = (FieldAccess)obj;
            return fa.getField().equals(this.getField()) && fa.getReceiver().equals(this.getReceiver());
        }

        public int hashCode() {
            return HashCodeUtils.hash(this.getField(), this.getReceiver());
        }

        @Override
        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return super.containsModifiableAliasOf(store, other) || this.receiver.containsModifiableAliasOf(store, other);
        }

        @Override
        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other) || this.receiver.containsSyntacticEqualReceiver(other);
        }

        @Override
        public boolean syntacticEquals(Receiver other) {
            if (!(other instanceof FieldAccess)) {
                return false;
            }
            FieldAccess fa = (FieldAccess)other;
            return super.syntacticEquals(other) || fa.getField().equals(this.getField()) && fa.getReceiver().syntacticEquals(this.getReceiver());
        }

        public String toString() {
            return this.receiver + "." + this.field;
        }

        @Override
        public boolean containsOfClass(Class<? extends Receiver> clazz) {
            return this.getClass().equals(clazz) || this.receiver.containsOfClass(clazz);
        }

        @Override
        public boolean isUnmodifiableByOtherCode() {
            return this.isFinal() && this.getReceiver().isUnmodifiableByOtherCode();
        }
    }

    public static abstract class Receiver {
        protected final TypeMirror type;

        public Receiver(TypeMirror type) {
            assert (type != null);
            this.type = type;
        }

        public TypeMirror getType() {
            return this.type;
        }

        public abstract boolean containsOfClass(Class<? extends Receiver> var1);

        public boolean containsUnknown() {
            return this.containsOfClass(Unknown.class);
        }

        public abstract boolean isUnmodifiableByOtherCode();

        public boolean syntacticEquals(Receiver other) {
            return other == this;
        }

        public boolean containsSyntacticEqualReceiver(Receiver other) {
            return this.syntacticEquals(other);
        }

        public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
            return this.equals(other) || store.canAlias(this, other);
        }
    }
}

