/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.dagger;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.dagger.DaggerAnnotations;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;

@BugPattern(name="PrivateConstructorForNoninstantiableModuleTest", summary="Add a private constructor to modules that will not be instantiated by Dagger.", explanation="Modules that contain abstract binding methods (@Binds, @Multibinds) or only static @Provides methods will not be instantiated by Dagger when they are included in a component.  Adding a private constructor clearly conveys that the module will not be used as an instance.", category=BugPattern.Category.DAGGER, severity=BugPattern.SeverityLevel.SUGGESTION)
public class PrivateConstructorForNoninstantiableModule
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Predicate<Tree> IS_CONSTRUCTOR = new Predicate<Tree>(){

        public boolean apply(Tree tree) {
            return ASTHelpers.getSymbol((Tree)tree).isConstructor();
        }
    };

    public Description matchClass(ClassTree classTree, VisitorState state) {
        if (!DaggerAnnotations.isAnyModule().matches((Tree)classTree, state)) {
            return Description.NO_MATCH;
        }
        if (!classTree.getKind().equals((Object)Tree.Kind.CLASS)) {
            return Description.NO_MATCH;
        }
        FluentIterable nonSyntheticMembers = FluentIterable.from(classTree.getMembers()).filter(Predicates.not((Predicate)new Predicate<Tree>(){

            public boolean apply(Tree tree) {
                return tree.getKind().equals((Object)Tree.Kind.METHOD) && ASTHelpers.isGeneratedConstructor((MethodTree)((MethodTree)tree));
            }
        }));
        if (nonSyntheticMembers.isEmpty()) {
            return Description.NO_MATCH;
        }
        if (nonSyntheticMembers.anyMatch(IS_CONSTRUCTOR)) {
            return Description.NO_MATCH;
        }
        boolean hasBindingDeclarationMethods = nonSyntheticMembers.anyMatch(PrivateConstructorForNoninstantiableModule.matcherAsPredicate(DaggerAnnotations.isBindingDeclarationMethod(), state));
        if (hasBindingDeclarationMethods) {
            return this.describeMatch(classTree, this.addPrivateConstructor(classTree, state));
        }
        boolean allStaticMembers = nonSyntheticMembers.allMatch(PrivateConstructorForNoninstantiableModule.matcherAsPredicate(Matchers.isStatic(), state));
        if (allStaticMembers) {
            return this.describeMatch(classTree, this.addPrivateConstructor(classTree, state));
        }
        return Description.NO_MATCH;
    }

    private Fix addPrivateConstructor(ClassTree classTree, VisitorState state) {
        return SuggestedFixes.addMembers((ClassTree)classTree, (VisitorState)state, (String)("private " + classTree.getSimpleName() + "() {}"), (String[])new String[0]);
    }

    private static <T extends Tree> Predicate<T> matcherAsPredicate(final Matcher<? super T> matcher, final VisitorState state) {
        return new Predicate<T>(){

            public boolean apply(T t) {
                return matcher.matches(t, state);
            }
        };
    }
}

