/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.Lazy;
import dagger.internal.Preconditions;
import javax.inject.Provider;

public final class DoubleCheck<T>
implements Provider<T>,
Lazy<T> {
    private static final Object UNINITIALIZED = new Object();
    private volatile Provider<T> provider;
    private volatile Object instance = UNINITIALIZED;

    private DoubleCheck(Provider<T> provider) {
        assert (provider != null);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Object result = this.instance;
        if (result == UNINITIALIZED) {
            DoubleCheck doubleCheck = this;
            synchronized (doubleCheck) {
                result = this.instance;
                if (result == UNINITIALIZED) {
                    result = this.provider.get();
                    Object currentInstance = this.instance;
                    if (currentInstance != UNINITIALIZED && currentInstance != result) {
                        String string = String.valueOf("Scoped provider was invoked recursively returning different results: ");
                        String string2 = String.valueOf(currentInstance);
                        String string3 = String.valueOf(result);
                        throw new IllegalStateException(new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string2).append(" & ").append(string3).toString());
                    }
                    this.instance = result;
                    this.provider = null;
                }
            }
        }
        return (T)result;
    }

    public static <T> Provider<T> provider(Provider<T> delegate) {
        Preconditions.checkNotNull(delegate);
        if (delegate instanceof DoubleCheck) {
            return delegate;
        }
        return new DoubleCheck<T>(delegate);
    }

    public static <T> Lazy<T> lazy(Provider<T> provider) {
        if (provider instanceof Lazy) {
            Lazy lazy = (Lazy)provider;
            return lazy;
        }
        return new DoubleCheck<T>(Preconditions.checkNotNull(provider));
    }
}

