/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.javac.util.Assert;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.Source;
import com.sun.tools.sjavac.pubapi.PubApi;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class Package
implements Comparable<Package> {
    private Module mod;
    private String name;
    private String dirname;
    private Set<String> dependents = new HashSet<String>();
    private Map<String, Set<String>> dependencies = new TreeMap<String, Set<String>>();
    private Map<String, Set<String>> cpDependencies = new TreeMap<String, Set<String>>();
    private PubApi pubApi = new PubApi();
    private Map<String, Source> sources = new HashMap<String, Source>();
    private Map<String, File> artifacts = new HashMap<String, File>();
    private static Pattern DEP_PATTERN = Pattern.compile("(.*) -> (.*)");

    public Package(Module m, String n) {
        int c = n.indexOf(":");
        Assert.check(c != -1);
        Assert.check(m.name().equals(m.name()));
        this.name = n;
        this.dirname = n.replace('.', File.separatorChar);
        if (m.name().length() > 0) {
            this.dirname = m.dirname() + File.separatorChar + this.dirname;
        }
    }

    public Module mod() {
        return this.mod;
    }

    public String name() {
        return this.name;
    }

    public String dirname() {
        return this.dirname;
    }

    public Map<String, Source> sources() {
        return this.sources;
    }

    public Map<String, File> artifacts() {
        return this.artifacts;
    }

    public PubApi getPubApi() {
        return this.pubApi;
    }

    public Map<String, Set<String>> typeDependencies() {
        return this.dependencies;
    }

    public Map<String, Set<String>> typeClasspathDependencies() {
        return this.cpDependencies;
    }

    public Set<String> dependents() {
        return this.dependents;
    }

    public boolean equals(Object o) {
        return o instanceof Package && this.name.equals(((Package)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Package o) {
        return this.name.compareTo(o.name);
    }

    public void addSource(Source s) {
        this.sources.put(s.file().getPath(), s);
    }

    public void parseAndAddDependency(String d, boolean cp) {
        Matcher m = DEP_PATTERN.matcher(d);
        if (!m.matches()) {
            throw new IllegalArgumentException("Bad dependency string: " + d);
        }
        this.addDependency(m.group(1), m.group(2), cp);
    }

    public void addDependency(String fullyQualifiedFrom, String fullyQualifiedTo, boolean cp) {
        Map<String, Set<String>> map;
        Map<String, Set<String>> map2 = map = cp ? this.cpDependencies : this.dependencies;
        if (!map.containsKey(fullyQualifiedFrom)) {
            map.put(fullyQualifiedFrom, new HashSet());
        }
        map.get(fullyQualifiedFrom).add(fullyQualifiedTo);
    }

    public void addDependent(String d) {
        this.dependents.add(d);
    }

    public boolean existsInJavacState() {
        return this.artifacts.size() > 0 || !this.pubApi.isEmpty();
    }

    public boolean hasPubApiChanged(PubApi newPubApi) {
        return !newPubApi.isBackwardCompatibleWith(this.pubApi);
    }

    public void setPubapi(PubApi newPubApi) {
        this.pubApi = newPubApi;
    }

    public void setDependencies(Map<String, Set<String>> ds, boolean cp) {
        (cp ? this.cpDependencies : this.dependencies).clear();
        for (String fullyQualifiedFrom : ds.keySet()) {
            for (String fullyQualifiedTo : ds.get(fullyQualifiedFrom)) {
                this.addDependency(fullyQualifiedFrom, fullyQualifiedTo, cp);
            }
        }
    }

    public void save(StringBuilder b) {
        b.append("P ").append(this.name).append("\n");
        Source.saveSources(this.sources, b);
        this.saveDependencies(b);
        this.savePubapi(b);
        this.saveArtifacts(b);
    }

    public static Package load(Module module, String l) {
        String name = l.substring(2);
        return new Package(module, name);
    }

    public void saveDependencies(StringBuilder b) {
        for (String fullyQualifiedFrom : this.dependencies.keySet()) {
            for (String fullyQualifiedTo : this.dependencies.get(fullyQualifiedFrom)) {
                b.append(String.format("D S %s -> %s%n", fullyQualifiedFrom, fullyQualifiedTo));
            }
        }
        for (String fullyQualifiedFrom : this.cpDependencies.keySet()) {
            for (String fullyQualifiedTo : this.cpDependencies.get(fullyQualifiedFrom)) {
                b.append(String.format("D C %s -> %s%n", fullyQualifiedFrom, fullyQualifiedTo));
            }
        }
    }

    public void savePubapi(StringBuilder b) {
        this.pubApi.asListOfStrings().stream().flatMap(l -> Stream.of("I ", l, "\n")).forEach(b::append);
    }

    public static void savePackages(Map<String, Package> packages, StringBuilder b) {
        ArrayList<String> sorted_packages = new ArrayList<String>();
        for (String key : packages.keySet()) {
            sorted_packages.add(key);
        }
        Collections.sort(sorted_packages);
        for (String s : sorted_packages) {
            Package p = packages.get(s);
            p.save(b);
        }
    }

    public void addArtifact(String a) {
        this.artifacts.put(a, new File(a));
    }

    public void addArtifact(File f) {
        this.artifacts.put(f.getPath(), f);
    }

    public void addArtifacts(Set<URI> as) {
        for (URI u : as) {
            this.addArtifact(new File(u));
        }
    }

    public void setArtifacts(Set<URI> as) {
        Assert.check(!this.artifacts.isEmpty());
        this.artifacts = new HashMap<String, File>();
        this.addArtifacts(as);
    }

    public void loadArtifact(String l) {
        int dp = l.indexOf(32, 2);
        String fn = l.substring(2, dp);
        long last_modified = Long.parseLong(l.substring(dp + 1));
        File f = new File(fn);
        if (f.exists() && f.lastModified() != last_modified) {
            Log.debug("Removing " + f.getPath() + " since its timestamp does not match javac_state.");
            f.delete();
        }
        this.artifacts.put(f.getPath(), f);
    }

    public void saveArtifacts(StringBuilder b) {
        ArrayList<File> sorted_artifacts = new ArrayList<File>();
        for (File f : this.artifacts.values()) {
            sorted_artifacts.add(f);
        }
        Collections.sort(sorted_artifacts);
        for (File f : sorted_artifacts) {
            b.append("A " + f.getPath() + " " + f.lastModified() + "\n");
        }
    }

    public void deleteArtifacts() {
        for (File a : this.artifacts.values()) {
            a.delete();
        }
    }
}

