/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.model;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.ListBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;

public class JavacTypes
implements Types {
    private final Symtab syms;
    private final com.sun.tools.javac.code.Types types;
    private static final Set<TypeKind> EXEC_OR_PKG = EnumSet.of(TypeKind.EXECUTABLE, TypeKind.PACKAGE);

    public static JavacTypes instance(Context context) {
        JavacTypes javacTypes = context.get(JavacTypes.class);
        if (javacTypes == null) {
            javacTypes = new JavacTypes(context);
        }
        return javacTypes;
    }

    protected JavacTypes(Context context) {
        context.put(JavacTypes.class, this);
        this.syms = Symtab.instance(context);
        this.types = com.sun.tools.javac.code.Types.instance(context);
    }

    @Override
    public Element asElement(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case DECLARED: 
            case INTERSECTION: 
            case ERROR: 
            case TYPEVAR: {
                Type type = JavacTypes.cast(Type.class, typeMirror);
                return type.asElement();
            }
        }
        return null;
    }

    @Override
    public boolean isSameType(TypeMirror typeMirror, TypeMirror typeMirror2) {
        return this.types.isSameType((Type)typeMirror, (Type)typeMirror2);
    }

    @Override
    public boolean isSubtype(TypeMirror typeMirror, TypeMirror typeMirror2) {
        this.validateTypeNotIn(typeMirror, EXEC_OR_PKG);
        this.validateTypeNotIn(typeMirror2, EXEC_OR_PKG);
        return this.types.isSubtype((Type)typeMirror, (Type)typeMirror2);
    }

    @Override
    public boolean isAssignable(TypeMirror typeMirror, TypeMirror typeMirror2) {
        this.validateTypeNotIn(typeMirror, EXEC_OR_PKG);
        this.validateTypeNotIn(typeMirror2, EXEC_OR_PKG);
        return this.types.isAssignable((Type)typeMirror, (Type)typeMirror2);
    }

    @Override
    public boolean contains(TypeMirror typeMirror, TypeMirror typeMirror2) {
        this.validateTypeNotIn(typeMirror, EXEC_OR_PKG);
        this.validateTypeNotIn(typeMirror2, EXEC_OR_PKG);
        return this.types.containsType((Type)typeMirror, (Type)typeMirror2);
    }

    @Override
    public boolean isSubsignature(ExecutableType executableType, ExecutableType executableType2) {
        return this.types.isSubSignature((Type)((Object)executableType), (Type)((Object)executableType2));
    }

    public List<Type> directSupertypes(TypeMirror typeMirror) {
        this.validateTypeNotIn(typeMirror, EXEC_OR_PKG);
        return this.types.directSupertypes((Type)typeMirror);
    }

    @Override
    public TypeMirror erasure(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.PACKAGE) {
            throw new IllegalArgumentException(typeMirror.toString());
        }
        return this.types.erasure((Type)typeMirror);
    }

    @Override
    public TypeElement boxedClass(PrimitiveType primitiveType) {
        return this.types.boxedClass((Type)((Object)primitiveType));
    }

    @Override
    public PrimitiveType unboxedType(TypeMirror typeMirror) {
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            throw new IllegalArgumentException(typeMirror.toString());
        }
        Type type = this.types.unboxedType((Type)typeMirror);
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException(typeMirror.toString());
        }
        return (PrimitiveType)((Object)type);
    }

    @Override
    public TypeMirror capture(TypeMirror typeMirror) {
        this.validateTypeNotIn(typeMirror, EXEC_OR_PKG);
        return this.types.capture((Type)typeMirror);
    }

    @Override
    public PrimitiveType getPrimitiveType(TypeKind typeKind) {
        switch (typeKind) {
            case BOOLEAN: {
                return this.syms.booleanType;
            }
            case BYTE: {
                return this.syms.byteType;
            }
            case SHORT: {
                return this.syms.shortType;
            }
            case INT: {
                return this.syms.intType;
            }
            case LONG: {
                return this.syms.longType;
            }
            case CHAR: {
                return this.syms.charType;
            }
            case FLOAT: {
                return this.syms.floatType;
            }
            case DOUBLE: {
                return this.syms.doubleType;
            }
        }
        throw new IllegalArgumentException("Not a primitive type: " + (Object)((Object)typeKind));
    }

    @Override
    public NullType getNullType() {
        return (NullType)((Object)this.syms.botType);
    }

    @Override
    public NoType getNoType(TypeKind typeKind) {
        switch (typeKind) {
            case VOID: {
                return this.syms.voidType;
            }
            case NONE: {
                return Type.noType;
            }
        }
        throw new IllegalArgumentException(typeKind.toString());
    }

    @Override
    public ArrayType getArrayType(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case VOID: 
            case EXECUTABLE: 
            case WILDCARD: 
            case PACKAGE: {
                throw new IllegalArgumentException(typeMirror.toString());
            }
        }
        return new Type.ArrayType((Type)typeMirror, this.syms.arrayClass, Type.noAnnotations);
    }

    @Override
    public WildcardType getWildcardType(TypeMirror typeMirror, TypeMirror typeMirror2) {
        Type type;
        BoundKind boundKind;
        if (typeMirror == null && typeMirror2 == null) {
            boundKind = BoundKind.UNBOUND;
            type = this.syms.objectType;
        } else if (typeMirror2 == null) {
            boundKind = BoundKind.EXTENDS;
            type = (Type)typeMirror;
        } else if (typeMirror == null) {
            boundKind = BoundKind.SUPER;
            type = (Type)typeMirror2;
        } else {
            throw new IllegalArgumentException("Extends and super bounds cannot both be provided");
        }
        switch (type.getKind()) {
            case DECLARED: 
            case ERROR: 
            case TYPEVAR: 
            case ARRAY: {
                return new Type.WildcardType(type, boundKind, (Symbol.TypeSymbol)this.syms.boundClass, Type.noAnnotations);
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    @Override
    public DeclaredType getDeclaredType(TypeElement typeElement, TypeMirror ... typeMirrorArray) {
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)typeElement;
        if (typeMirrorArray.length == 0) {
            return (DeclaredType)((Object)classSymbol.erasure(this.types));
        }
        if (classSymbol.type.getEnclosingType().isParameterized()) {
            throw new IllegalArgumentException(classSymbol.toString());
        }
        return this.getDeclaredType0(classSymbol.type.getEnclosingType(), classSymbol, typeMirrorArray);
    }

    @Override
    public DeclaredType getDeclaredType(DeclaredType declaredType, TypeElement typeElement, TypeMirror ... typeMirrorArray) {
        if (declaredType == null) {
            return this.getDeclaredType(typeElement, typeMirrorArray);
        }
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)typeElement;
        Type type = (Type)((Object)declaredType);
        if (type.tsym != classSymbol.owner.enclClass()) {
            throw new IllegalArgumentException(declaredType.toString());
        }
        if (!type.isParameterized()) {
            return this.getDeclaredType(typeElement, typeMirrorArray);
        }
        return this.getDeclaredType0(type, classSymbol, typeMirrorArray);
    }

    private DeclaredType getDeclaredType0(Type type, Symbol.ClassSymbol classSymbol, TypeMirror ... typeMirrorArray) {
        if (typeMirrorArray.length != classSymbol.type.getTypeArguments().length()) {
            throw new IllegalArgumentException("Incorrect number of type arguments");
        }
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (TypeMirror typeMirror : typeMirrorArray) {
            if (!(typeMirror instanceof ReferenceType) && !(typeMirror instanceof WildcardType)) {
                throw new IllegalArgumentException(typeMirror.toString());
            }
            listBuffer.append((Type)typeMirror);
        }
        return new Type.ClassType(type, listBuffer.toList(), classSymbol, Type.noAnnotations);
    }

    @Override
    public TypeMirror asMemberOf(DeclaredType declaredType, Element element) {
        Type type = (Type)((Object)declaredType);
        Symbol symbol = (Symbol)element;
        if (this.types.asSuper(type, symbol.getEnclosingElement()) == null) {
            throw new IllegalArgumentException(symbol + "@" + type);
        }
        return this.types.memberType(type, symbol);
    }

    private void validateTypeNotIn(TypeMirror typeMirror, Set<TypeKind> set) {
        if (set.contains((Object)typeMirror.getKind())) {
            throw new IllegalArgumentException(typeMirror.toString());
        }
    }

    private static <T> T cast(Class<T> clazz, Object object) {
        if (!clazz.isInstance(object)) {
            throw new IllegalArgumentException(object.toString());
        }
        return clazz.cast(object);
    }

    public Set<Symbol.MethodSymbol> getOverriddenMethods(Element element) {
        if (element.getKind() != ElementKind.METHOD || element.getModifiers().contains((Object)Modifier.STATIC) || element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return Collections.emptySet();
        }
        if (!(element instanceof Symbol.MethodSymbol)) {
            throw new IllegalArgumentException();
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)element;
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)methodSymbol.owner;
        LinkedHashSet<Symbol.MethodSymbol> linkedHashSet = new LinkedHashSet<Symbol.MethodSymbol>();
        for (Type type : this.types.closure(classSymbol.type)) {
            if (type == classSymbol.type) continue;
            Symbol.ClassSymbol classSymbol2 = (Symbol.ClassSymbol)type.tsym;
            for (Symbol symbol : classSymbol2.members().getSymbolsByName(methodSymbol.name)) {
                if (symbol.kind != 16 || !methodSymbol.overrides(symbol, classSymbol, this.types, true)) continue;
                linkedHashSet.add((Symbol.MethodSymbol)symbol);
            }
        }
        return linkedHashSet;
    }
}

