/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.Locations;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public abstract class BaseFileManager
implements JavaFileManager {
    public Log log;
    protected Charset charset;
    protected Options options;
    protected String classLoaderClass;
    protected Locations locations;
    private static final Set<Option> javacFileManagerOptions = Option.getJavacFileManagerOptions();
    private String defaultEncodingName;
    private final ByteBufferCache byteBufferCache;
    protected final Map<JavaFileObject, ContentCacheEntry> contentCache = new HashMap<JavaFileObject, ContentCacheEntry>();

    protected BaseFileManager(Charset charset) {
        this.charset = charset;
        this.byteBufferCache = new ByteBufferCache();
        this.locations = this.createLocations();
    }

    public void setContext(Context context) {
        this.log = Log.instance(context);
        this.options = Options.instance(context);
        this.classLoaderClass = this.options.get("procloader");
        this.locations.update(this.log, Lint.instance(context), FSInfo.instance(context));
    }

    protected Locations createLocations() {
        return new Locations();
    }

    protected Source getSource() {
        String string = this.options.get(Option.SOURCE);
        Source source = null;
        if (string != null) {
            source = Source.lookup(string);
        }
        return source != null ? source : Source.DEFAULT;
    }

    protected ClassLoader getClassLoader(URL[] uRLArray) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (this.classLoaderClass != null) {
            try {
                Class<ClassLoader> clazz = Class.forName(this.classLoaderClass).asSubclass(ClassLoader.class);
                Class[] classArray = new Class[]{URL[].class, ClassLoader.class};
                Constructor<ClassLoader> constructor = clazz.getConstructor(classArray);
                return constructor.newInstance(uRLArray, classLoader);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return new URLClassLoader(uRLArray, classLoader);
    }

    public boolean isDefaultBootClassPath() {
        return this.locations.isDefaultBootClassPath();
    }

    @Override
    public boolean handleOption(String string, Iterator<String> iterator) {
        OptionHelper.GrumpyHelper grumpyHelper = new OptionHelper.GrumpyHelper(this.log){

            @Override
            public String get(Option option) {
                return BaseFileManager.this.options.get(option.getText());
            }

            @Override
            public void put(String string, String string2) {
                BaseFileManager.this.options.put(string, string2);
            }

            @Override
            public void remove(String string) {
                BaseFileManager.this.options.remove(string);
            }

            @Override
            public boolean handleFileManagerOption(Option option, String string) {
                return BaseFileManager.this.handleOption(option, string);
            }
        };
        for (Option option : javacFileManagerOptions) {
            if (!option.matches(string)) continue;
            if (option.hasArg() ? iterator.hasNext() && !option.process(grumpyHelper, string, iterator.next()) : !option.process(grumpyHelper, string)) {
                return true;
            }
            throw new IllegalArgumentException(string);
        }
        return false;
    }

    @Override
    public int isSupportedOption(String string) {
        for (Option option : javacFileManagerOptions) {
            if (!option.matches(string)) continue;
            return option.hasArg() ? 1 : 0;
        }
        return -1;
    }

    public boolean handleOption(Option option, String string) {
        return this.locations.handleOption(option, string);
    }

    public boolean handleOptions(Map<Option, String> map) {
        boolean bl = true;
        for (Map.Entry<Option, String> entry : map.entrySet()) {
            bl &= this.handleOption(entry.getKey(), entry.getValue());
        }
        return bl;
    }

    private String getDefaultEncodingName() {
        if (this.defaultEncodingName == null) {
            this.defaultEncodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
        }
        return this.defaultEncodingName;
    }

    public String getEncodingName() {
        String string = this.options.get(Option.ENCODING);
        if (string == null) {
            return this.getDefaultEncodingName();
        }
        return string;
    }

    public CharBuffer decode(ByteBuffer byteBuffer, boolean bl) {
        CoderResult coderResult;
        CharsetDecoder charsetDecoder;
        String string = this.getEncodingName();
        try {
            charsetDecoder = this.getDecoder(string, bl);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
            this.log.error("unsupported.encoding", string);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        float f = charsetDecoder.averageCharsPerByte() * 0.8f + charsetDecoder.maxCharsPerByte() * 0.2f;
        CharBuffer charBuffer = CharBuffer.allocate(10 + (int)((float)byteBuffer.remaining() * f));
        while (true) {
            coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            charBuffer.flip();
            if (coderResult.isUnderflow()) {
                if (charBuffer.limit() == charBuffer.capacity()) {
                    charBuffer = CharBuffer.allocate(charBuffer.capacity() + 1).put(charBuffer);
                    charBuffer.flip();
                }
                return charBuffer;
            }
            if (coderResult.isOverflow()) {
                int n = 10 + charBuffer.capacity() + (int)((float)byteBuffer.remaining() * charsetDecoder.maxCharsPerByte());
                charBuffer = CharBuffer.allocate(n).put(charBuffer);
                continue;
            }
            if (!coderResult.isMalformed() && !coderResult.isUnmappable()) break;
            this.log.error(new JCDiagnostic.SimpleDiagnosticPosition(charBuffer.limit()), "illegal.char.for.encoding", this.charset == null ? string : this.charset.name());
            byteBuffer.position(byteBuffer.position() + coderResult.length());
            charBuffer.position(charBuffer.limit());
            charBuffer.limit(charBuffer.capacity());
            charBuffer.put('\ufffd');
        }
        throw new AssertionError(coderResult);
    }

    public CharsetDecoder getDecoder(String string, boolean bl) {
        Charset charset = this.charset == null ? Charset.forName(string) : this.charset;
        CharsetDecoder charsetDecoder = charset.newDecoder();
        CodingErrorAction codingErrorAction = bl ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT;
        return charsetDecoder.onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction);
    }

    public ByteBuffer makeByteBuffer(InputStream inputStream) throws IOException {
        int n = inputStream.available();
        if (n < 1024) {
            n = 1024;
        }
        ByteBuffer byteBuffer = this.byteBufferCache.get(n);
        int n2 = 0;
        while (inputStream.available() != 0) {
            int n3;
            if (n2 >= n) {
                byteBuffer = ByteBuffer.allocate(n <<= 1).put((ByteBuffer)byteBuffer.flip());
            }
            if ((n3 = inputStream.read(byteBuffer.array(), n2, n - n2)) < 0) break;
            byteBuffer.position(n2 += n3);
        }
        return (ByteBuffer)byteBuffer.flip();
    }

    public void recycleByteBuffer(ByteBuffer byteBuffer) {
        this.byteBufferCache.put(byteBuffer);
    }

    public CharBuffer getCachedContent(JavaFileObject javaFileObject) {
        ContentCacheEntry contentCacheEntry = this.contentCache.get(javaFileObject);
        if (contentCacheEntry == null) {
            return null;
        }
        if (!contentCacheEntry.isValid(javaFileObject)) {
            this.contentCache.remove(javaFileObject);
            return null;
        }
        return contentCacheEntry.getValue();
    }

    public void cache(JavaFileObject javaFileObject, CharBuffer charBuffer) {
        this.contentCache.put(javaFileObject, new ContentCacheEntry(javaFileObject, charBuffer));
    }

    public void flushCache(JavaFileObject javaFileObject) {
        this.contentCache.remove(javaFileObject);
    }

    public static JavaFileObject.Kind getKind(String string) {
        if (string.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (string.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (string.endsWith(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    protected static <T> T nullCheck(T t) {
        t.getClass();
        return t;
    }

    protected static <T> Collection<T> nullCheck(Collection<T> collection) {
        for (T t : collection) {
            t.getClass();
        }
        return collection;
    }

    protected static class ContentCacheEntry {
        final long timestamp;
        final SoftReference<CharBuffer> ref;

        ContentCacheEntry(JavaFileObject javaFileObject, CharBuffer charBuffer) {
            this.timestamp = javaFileObject.getLastModified();
            this.ref = new SoftReference<CharBuffer>(charBuffer);
        }

        boolean isValid(JavaFileObject javaFileObject) {
            return this.timestamp == javaFileObject.getLastModified();
        }

        CharBuffer getValue() {
            return this.ref.get();
        }
    }

    private static class ByteBufferCache {
        private ByteBuffer cached;

        private ByteBufferCache() {
        }

        ByteBuffer get(int n) {
            if (n < 20480) {
                n = 20480;
            }
            ByteBuffer byteBuffer = this.cached != null && this.cached.capacity() >= n ? (ByteBuffer)this.cached.clear() : ByteBuffer.allocate(n + n >> 1);
            this.cached = null;
            return byteBuffer;
        }

        void put(ByteBuffer byteBuffer) {
            this.cached = byteBuffer;
        }
    }
}

