/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.operations;

import com.hazelcast.concurrent.lock.LockStoreImpl;
import com.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.hazelcast.concurrent.lock.operations.BaseLockOperation;
import com.hazelcast.concurrent.lock.operations.LockBackupOperation;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.WaitSupport;
import java.io.Serializable;

public class LockOperation
extends BaseLockOperation
implements WaitSupport,
BackupAwareOperation {
    public LockOperation() {
    }

    public LockOperation(ObjectNamespace namespace, Data key, long threadId, long leaseTime, long timeout) {
        super(namespace, key, threadId, leaseTime, timeout);
    }

    @Override
    public void run() throws Exception {
        this.response = this.getLockStore().lock(this.key, this.getCallerUuid(), this.threadId, this.getReferenceCallId(), this.leaseTime);
    }

    @Override
    public Operation getBackupOperation() {
        LockBackupOperation operation = new LockBackupOperation(this.namespace, this.key, this.threadId, this.leaseTime, this.getCallerUuid());
        operation.setReferenceCallId(this.getReferenceCallId());
        return operation;
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public final WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(this.namespace, this.key);
    }

    @Override
    public final boolean shouldWait() {
        LockStoreImpl lockStore = this.getLockStore();
        return this.getWaitTimeout() != 0L && !lockStore.canAcquireLock(this.key, this.getCallerUuid(), this.threadId);
    }

    @Override
    public final void onWaitExpire() {
        long timeout = this.getWaitTimeout();
        Serializable response = timeout < 0L || timeout == Long.MAX_VALUE ? new OperationTimeoutException() : Boolean.FALSE;
        this.sendResponse(response);
    }

    @Override
    public int getId() {
        return 8;
    }
}

