/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.Dependencies;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import javax.lang.model.SourceVersion;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class ClassFinder {
    protected static final Context.Key<ClassFinder> classFinderKey = new Context.Key();
    ClassReader reader;
    Annotate annotate;
    boolean verbose;
    private boolean cacheCompletionFailure;
    protected boolean preferSource;
    protected boolean userPathsFirst;
    final Log log;
    Symtab syms;
    final Names names;
    final Name completionFailureName;
    private final JavaFileManager fileManager;
    private final Dependencies dependencies;
    JCDiagnostic.Factory diagFactory;
    public Symbol.Completer sourceCompleter = null;
    protected JavaFileObject currentClassFile = null;
    protected Symbol currentOwner = null;
    private final Symbol.Completer thisCompleter = new Symbol.Completer(){

        @Override
        public void complete(Symbol symbol) throws Symbol.CompletionFailure {
            ClassFinder.this.complete(symbol);
        }
    };
    private Symbol.CompletionFailure cachedCompletionFailure = new Symbol.CompletionFailure(null, (JCDiagnostic)null);
    protected JavaFileManager.Location currentLoc;
    private boolean verbosePath;
    private boolean preferCurrent;

    public Symbol.Completer getCompleter() {
        return this.thisCompleter;
    }

    public static ClassFinder instance(Context context) {
        ClassFinder classFinder = context.get(classFinderKey);
        if (classFinder == null) {
            classFinder = new ClassFinder(context);
        }
        return classFinder;
    }

    protected ClassFinder(Context context) {
        this.cachedCompletionFailure.setStackTrace(new StackTraceElement[0]);
        this.verbosePath = true;
        context.put(classFinderKey, this);
        this.reader = ClassReader.instance(context);
        this.names = Names.instance(context);
        this.syms = Symtab.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.dependencies = Dependencies.instance(context);
        if (this.fileManager == null) {
            throw new AssertionError((Object)"FileManager initialization error");
        }
        this.diagFactory = JCDiagnostic.Factory.instance(context);
        this.log = Log.instance(context);
        this.annotate = Annotate.instance(context);
        Options options = Options.instance(context);
        this.verbose = options.isSet(Option.VERBOSE);
        this.cacheCompletionFailure = options.isUnset("dev");
        this.preferSource = "source".equals(options.get("-Xprefer"));
        this.userPathsFirst = options.isSet(Option.XXUSERPATHSFIRST);
        this.completionFailureName = options.isSet("failcomplete") ? this.names.fromString(options.get("failcomplete")) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete(Symbol symbol) throws Symbol.CompletionFailure {
        if (symbol.kind == 2) {
            try {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
                this.dependencies.push(classSymbol);
                classSymbol.members_field = new Scope.ErrorScope(classSymbol);
                this.annotate.enterStart();
                try {
                    this.completeOwners(classSymbol.owner);
                    this.completeEnclosing(classSymbol);
                }
                finally {
                    this.annotate.enterDoneWithoutFlush();
                }
                this.fillIn(classSymbol);
            }
            finally {
                this.dependencies.pop();
            }
        }
        if (symbol.kind == 1) {
            Symbol.PackageSymbol packageSymbol = (Symbol.PackageSymbol)symbol;
            try {
                this.fillIn(packageSymbol);
            }
            catch (IOException iOException) {
                throw new Symbol.CompletionFailure(symbol, iOException.getLocalizedMessage()).initCause(iOException);
            }
        }
        if (!this.reader.filling) {
            this.annotate.flush();
        }
    }

    private void completeOwners(Symbol symbol) {
        if (symbol.kind != 1) {
            this.completeOwners(symbol.owner);
        }
        symbol.complete();
    }

    private void completeEnclosing(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.owner.kind == 1) {
            Symbol symbol = classSymbol.owner;
            for (Name name : Convert.enclosingCandidates(Convert.shortName(classSymbol.name))) {
                Symbol symbol2 = symbol.members().findFirst(name);
                if (symbol2 == null) {
                    symbol2 = this.syms.classes.get(Symbol.TypeSymbol.formFlatName(name, symbol));
                }
                if (symbol2 == null) continue;
                symbol2.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillIn(Symbol.ClassSymbol classSymbol) {
        if (this.completionFailureName == classSymbol.fullname) {
            throw new Symbol.CompletionFailure((Symbol)classSymbol, "user-selected completion failure by class name");
        }
        this.currentOwner = classSymbol;
        JavaFileObject javaFileObject = classSymbol.classfile;
        if (javaFileObject != null) {
            JavaFileObject javaFileObject2 = this.currentClassFile;
            try {
                if (this.reader.filling) {
                    Assert.error("Filling " + javaFileObject.toUri() + " during " + javaFileObject2);
                }
                this.currentClassFile = javaFileObject;
                if (this.verbose) {
                    this.log.printVerbose("loading", this.currentClassFile.toString());
                }
                if (javaFileObject.getKind() == JavaFileObject.Kind.CLASS) {
                    this.reader.readClassFile(classSymbol);
                }
                if (this.sourceCompleter != null) {
                    this.sourceCompleter.complete(classSymbol);
                }
                throw new IllegalStateException("Source completer required to read " + javaFileObject.toUri());
            }
            finally {
                this.currentClassFile = javaFileObject2;
            }
        } else {
            JCDiagnostic jCDiagnostic = this.diagFactory.fragment("class.file.not.found", classSymbol.flatname);
            throw this.newCompletionFailure(classSymbol, jCDiagnostic);
        }
    }

    private Symbol.CompletionFailure newCompletionFailure(Symbol.TypeSymbol typeSymbol, JCDiagnostic jCDiagnostic) {
        if (!this.cacheCompletionFailure) {
            return new Symbol.CompletionFailure((Symbol)typeSymbol, jCDiagnostic);
        }
        Symbol.CompletionFailure completionFailure = this.cachedCompletionFailure;
        completionFailure.sym = typeSymbol;
        completionFailure.diag = jCDiagnostic;
        return completionFailure;
    }

    public Symbol.ClassSymbol loadClass(Name name) throws Symbol.CompletionFailure {
        boolean bl = this.syms.classes.get(name) == null;
        Symbol.ClassSymbol classSymbol = this.syms.enterClass(name);
        if (classSymbol.members_field == null && classSymbol.completer != null) {
            try {
                classSymbol.complete();
            }
            catch (Symbol.CompletionFailure completionFailure) {
                if (bl) {
                    this.syms.classes.remove(name);
                }
                throw completionFailure;
            }
        }
        return classSymbol;
    }

    protected void includeClassFile(Symbol.PackageSymbol packageSymbol, JavaFileObject javaFileObject) {
        Symbol.ClassSymbol classSymbol;
        Object object;
        if ((packageSymbol.flags_field & 0x800000L) == 0L) {
            object = packageSymbol;
            while (object != null && object.kind == 1) {
                object.flags_field |= 0x800000L;
                object = object.owner;
            }
        }
        int n = (object = javaFileObject.getKind()) == JavaFileObject.Kind.CLASS ? 0x2000000 : 0x4000000;
        String string = this.fileManager.inferBinaryName(this.currentLoc, javaFileObject);
        int n2 = string.lastIndexOf(".");
        Name name = this.names.fromString(string.substring(n2 + 1));
        boolean bl = name == this.names.package_info;
        Symbol.ClassSymbol classSymbol2 = classSymbol = bl ? packageSymbol.package_info : (Symbol.ClassSymbol)packageSymbol.members_field.findFirst(name);
        if (classSymbol == null) {
            classSymbol = this.syms.enterClass(name, packageSymbol);
            if (classSymbol.classfile == null) {
                classSymbol.classfile = javaFileObject;
            }
            if (bl) {
                packageSymbol.package_info = classSymbol;
            } else if (classSymbol.owner == packageSymbol) {
                packageSymbol.members_field.enter(classSymbol);
            }
        } else if (!this.preferCurrent && classSymbol.classfile != null && (classSymbol.flags_field & (long)n) == 0L && (classSymbol.flags_field & 0x6000000L) != 0L) {
            classSymbol.classfile = this.preferredFileObject(javaFileObject, classSymbol.classfile);
        }
        classSymbol.flags_field |= (long)n;
    }

    protected JavaFileObject preferredFileObject(JavaFileObject javaFileObject, JavaFileObject javaFileObject2) {
        long l;
        if (this.preferSource) {
            return javaFileObject.getKind() == JavaFileObject.Kind.SOURCE ? javaFileObject : javaFileObject2;
        }
        long l2 = javaFileObject.getLastModified();
        return l2 > (l = javaFileObject2.getLastModified()) ? javaFileObject : javaFileObject2;
    }

    protected EnumSet<JavaFileObject.Kind> getPackageFileKinds() {
        return EnumSet.of(JavaFileObject.Kind.CLASS, JavaFileObject.Kind.SOURCE);
    }

    protected void extraFileActions(Symbol.PackageSymbol packageSymbol, JavaFileObject javaFileObject) {
    }

    private void fillIn(Symbol.PackageSymbol packageSymbol) throws IOException {
        if (packageSymbol.members_field == null) {
            packageSymbol.members_field = Scope.WriteableScope.create(packageSymbol);
        }
        this.preferCurrent = false;
        if (this.userPathsFirst) {
            this.scanUserPaths(packageSymbol);
            this.preferCurrent = true;
            this.scanPlatformPath(packageSymbol);
        } else {
            this.scanPlatformPath(packageSymbol);
            this.scanUserPaths(packageSymbol);
        }
        this.verbosePath = false;
    }

    private void scanUserPaths(Symbol.PackageSymbol packageSymbol) throws IOException {
        Object object;
        EnumSet<JavaFileObject.Kind> enumSet = this.getPackageFileKinds();
        EnumSet<JavaFileObject.Kind> enumSet2 = EnumSet.copyOf(enumSet);
        enumSet2.remove((Object)JavaFileObject.Kind.SOURCE);
        boolean bl = !enumSet2.isEmpty();
        EnumSet<JavaFileObject.Kind> enumSet3 = EnumSet.copyOf(enumSet);
        enumSet3.remove((Object)JavaFileObject.Kind.CLASS);
        boolean bl2 = !enumSet3.isEmpty();
        boolean bl3 = this.fileManager.hasLocation(StandardLocation.SOURCE_PATH);
        if (this.verbose && this.verbosePath && this.fileManager instanceof StandardJavaFileManager) {
            List<Object> list;
            object = (StandardJavaFileManager)this.fileManager;
            if (bl3 && bl2) {
                list = List.nil();
                for (File file : object.getLocation(StandardLocation.SOURCE_PATH)) {
                    list = list.prepend(file);
                }
                this.log.printVerbose("sourcepath", list.reverse().toString());
            } else if (bl2) {
                list = List.nil();
                for (File file : object.getLocation(StandardLocation.CLASS_PATH)) {
                    list = list.prepend(file);
                }
                this.log.printVerbose("sourcepath", list.reverse().toString());
            }
            if (bl) {
                list = List.nil();
                for (File file : object.getLocation(StandardLocation.PLATFORM_CLASS_PATH)) {
                    list = list.prepend(file);
                }
                for (File file : object.getLocation(StandardLocation.CLASS_PATH)) {
                    list = list.prepend(file);
                }
                this.log.printVerbose("classpath", list.reverse().toString());
            }
        }
        object = packageSymbol.fullname.toString();
        if (bl2 && !bl3) {
            this.fillIn(packageSymbol, StandardLocation.CLASS_PATH, this.fileManager.list(StandardLocation.CLASS_PATH, (String)object, enumSet, false));
        } else {
            if (bl) {
                this.fillIn(packageSymbol, StandardLocation.CLASS_PATH, this.fileManager.list(StandardLocation.CLASS_PATH, (String)object, enumSet2, false));
            }
            if (bl2) {
                this.fillIn(packageSymbol, StandardLocation.SOURCE_PATH, this.fileManager.list(StandardLocation.SOURCE_PATH, (String)object, enumSet3, false));
            }
        }
    }

    private void scanPlatformPath(Symbol.PackageSymbol packageSymbol) throws IOException {
        this.fillIn(packageSymbol, StandardLocation.PLATFORM_CLASS_PATH, this.fileManager.list(StandardLocation.PLATFORM_CLASS_PATH, packageSymbol.fullname.toString(), EnumSet.of(JavaFileObject.Kind.CLASS), false));
    }

    private void fillIn(Symbol.PackageSymbol packageSymbol, JavaFileManager.Location location, Iterable<JavaFileObject> iterable) {
        this.currentLoc = location;
        block3: for (JavaFileObject javaFileObject : iterable) {
            switch (javaFileObject.getKind()) {
                case CLASS: 
                case SOURCE: {
                    String string = this.fileManager.inferBinaryName(this.currentLoc, javaFileObject);
                    String string2 = string.substring(string.lastIndexOf(".") + 1);
                    if (!SourceVersion.isIdentifier(string2) && !string2.equals("package-info")) continue block3;
                    this.includeClassFile(packageSymbol, javaFileObject);
                    continue block3;
                }
            }
            this.extraFileActions(packageSymbol, javaFileObject);
        }
    }

    public static class BadClassFile
    extends Symbol.CompletionFailure {
        private static final long serialVersionUID = 0L;

        public BadClassFile(Symbol.TypeSymbol typeSymbol, JavaFileObject javaFileObject, JCDiagnostic jCDiagnostic, JCDiagnostic.Factory factory) {
            super((Symbol)typeSymbol, BadClassFile.createBadClassFileDiagnostic(javaFileObject, jCDiagnostic, factory));
        }

        private static JCDiagnostic createBadClassFileDiagnostic(JavaFileObject javaFileObject, JCDiagnostic jCDiagnostic, JCDiagnostic.Factory factory) {
            String string = javaFileObject.getKind() == JavaFileObject.Kind.SOURCE ? "bad.source.file.header" : "bad.class.file.header";
            return factory.fragment(string, javaFileObject, jCDiagnostic);
        }
    }
}

