/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.file.ZipArchive;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;

public class SymbolArchive
extends ZipArchive {
    final File origFile;
    final RelativePath.RelativeDirectory prefix;

    public SymbolArchive(JavacFileManager javacFileManager, File file, ZipFile zipFile, RelativePath.RelativeDirectory relativeDirectory) throws IOException {
        super(javacFileManager, zipFile, false);
        this.origFile = file;
        this.prefix = relativeDirectory;
        this.initMap();
    }

    @Override
    void addZipEntry(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        if (!string.startsWith(this.prefix.path)) {
            return;
        }
        string = string.substring(this.prefix.path.length());
        int n = string.lastIndexOf(47);
        RelativePath.RelativeDirectory relativeDirectory = new RelativePath.RelativeDirectory(string.substring(0, n + 1));
        String string2 = string.substring(n + 1);
        if (string2.length() == 0) {
            return;
        }
        List<String> list = (List<String>)this.map.get(relativeDirectory);
        if (list == null) {
            list = List.nil();
        }
        list = list.prepend(string2);
        this.map.put(relativeDirectory, list);
    }

    @Override
    public JavaFileObject getFileObject(RelativePath.RelativeDirectory relativeDirectory, String string) {
        RelativePath.RelativeDirectory relativeDirectory2 = new RelativePath.RelativeDirectory(this.prefix, relativeDirectory.path);
        ZipEntry zipEntry = new RelativePath.RelativeFile(relativeDirectory2, string).getZipEntry(this.zfile);
        return new SymbolFileObject(this, string, zipEntry);
    }

    @Override
    public String toString() {
        return "SymbolArchive[" + this.zfile.getName() + "]";
    }

    public static class SymbolFileObject
    extends ZipArchive.ZipFileObject {
        protected SymbolFileObject(SymbolArchive symbolArchive, String string, ZipEntry zipEntry) {
            super(symbolArchive, string, zipEntry);
        }

        @Override
        protected String inferBinaryName(Iterable<? extends File> iterable) {
            String string;
            String string2 = this.entry.getName();
            if (string2.startsWith(string = ((SymbolArchive)this.zarch).prefix.path)) {
                string2 = string2.substring(string.length());
            }
            return SymbolFileObject.removeExtension(string2).replace('/', '.');
        }
    }
}

