/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.api.Formattable;
import com.sun.tools.javac.api.Messages;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.Locale;

public class Tokens {
    private final Names names;
    private final TokenKind[] key;
    private int maxKey = 0;
    private Name[] tokenName = new Name[TokenKind.values().length];
    public static final Context.Key<Tokens> tokensKey = new Context.Key();
    public static final Token DUMMY = new Token(TokenKind.ERROR, 0, 0, null);

    public static Tokens instance(Context context) {
        Tokens tokens = context.get(tokensKey);
        if (tokens == null) {
            tokens = new Tokens(context);
        }
        return tokens;
    }

    protected Tokens(Context context) {
        context.put(tokensKey, this);
        this.names = Names.instance(context);
        for (TokenKind tokenKind : TokenKind.values()) {
            if (tokenKind.name != null) {
                this.enterKeyword(tokenKind.name, tokenKind);
                continue;
            }
            this.tokenName[tokenKind.ordinal()] = null;
        }
        this.key = new TokenKind[this.maxKey + 1];
        for (int i = 0; i <= this.maxKey; ++i) {
            this.key[i] = TokenKind.IDENTIFIER;
        }
        for (TokenKind tokenKind : TokenKind.values()) {
            if (tokenKind.name == null) continue;
            this.key[this.tokenName[tokenKind.ordinal()].getIndex()] = tokenKind;
        }
    }

    private void enterKeyword(String string, TokenKind tokenKind) {
        Name name;
        this.tokenName[tokenKind.ordinal()] = name = this.names.fromString(string);
        if (name.getIndex() > this.maxKey) {
            this.maxKey = name.getIndex();
        }
    }

    TokenKind lookupKind(Name name) {
        return name.getIndex() > this.maxKey ? TokenKind.IDENTIFIER : this.key[name.getIndex()];
    }

    TokenKind lookupKind(String string) {
        return this.lookupKind(this.names.fromString(string));
    }

    static final class NumericToken
    extends StringToken {
        public final int radix;

        public NumericToken(TokenKind tokenKind, int n, int n2, String string, int n3, List<Comment> list) {
            super(tokenKind, n, n2, string, list);
            this.radix = n3;
        }

        @Override
        protected void checkKind() {
            if (this.kind.tag != Token.Tag.NUMERIC) {
                throw new AssertionError((Object)("Bad token kind - expected " + (Object)((Object)Token.Tag.NUMERIC)));
            }
        }

        @Override
        public int radix() {
            return this.radix;
        }
    }

    static class StringToken
    extends Token {
        public final String stringVal;

        public StringToken(TokenKind tokenKind, int n, int n2, String string, List<Comment> list) {
            super(tokenKind, n, n2, list);
            this.stringVal = string;
        }

        @Override
        protected void checkKind() {
            if (this.kind.tag != Token.Tag.STRING) {
                throw new AssertionError((Object)("Bad token kind - expected " + (Object)((Object)Token.Tag.STRING)));
            }
        }

        @Override
        public String stringVal() {
            return this.stringVal;
        }
    }

    static final class NamedToken
    extends Token {
        public final Name name;

        public NamedToken(TokenKind tokenKind, int n, int n2, Name name, List<Comment> list) {
            super(tokenKind, n, n2, list);
            this.name = name;
        }

        @Override
        protected void checkKind() {
            if (this.kind.tag != Token.Tag.NAMED) {
                throw new AssertionError((Object)("Bad token kind - expected " + (Object)((Object)Token.Tag.NAMED)));
            }
        }

        @Override
        public Name name() {
            return this.name;
        }
    }

    public static class Token {
        public final TokenKind kind;
        public final int pos;
        public final int endPos;
        public final List<Comment> comments;

        Token(TokenKind tokenKind, int n, int n2, List<Comment> list) {
            this.kind = tokenKind;
            this.pos = n;
            this.endPos = n2;
            this.comments = list;
            this.checkKind();
        }

        Token[] split(Tokens tokens) {
            if (this.kind.name.length() < 2 || this.kind.tag != Tag.DEFAULT) {
                throw new AssertionError((Object)("Cant split" + this.kind));
            }
            TokenKind tokenKind = tokens.lookupKind(this.kind.name.substring(0, 1));
            TokenKind tokenKind2 = tokens.lookupKind(this.kind.name.substring(1));
            if (tokenKind == null || tokenKind2 == null) {
                throw new AssertionError((Object)"Cant split - bad subtokens");
            }
            return new Token[]{new Token(tokenKind, this.pos, this.pos + tokenKind.name.length(), this.comments), new Token(tokenKind2, this.pos + tokenKind.name.length(), this.endPos, null)};
        }

        protected void checkKind() {
            if (this.kind.tag != Tag.DEFAULT) {
                throw new AssertionError((Object)("Bad token kind - expected " + (Object)((Object)Tag.STRING)));
            }
        }

        public Name name() {
            throw new UnsupportedOperationException();
        }

        public String stringVal() {
            throw new UnsupportedOperationException();
        }

        public int radix() {
            throw new UnsupportedOperationException();
        }

        public Comment comment(Comment.CommentStyle commentStyle) {
            List<Comment> list = this.getComments(Comment.CommentStyle.JAVADOC);
            return list.isEmpty() ? null : (Comment)list.head;
        }

        public boolean deprecatedFlag() {
            for (Comment comment : this.getComments(Comment.CommentStyle.JAVADOC)) {
                if (!comment.isDeprecated()) continue;
                return true;
            }
            return false;
        }

        private List<Comment> getComments(Comment.CommentStyle commentStyle) {
            if (this.comments == null) {
                return List.nil();
            }
            ListBuffer<Comment> listBuffer = new ListBuffer<Comment>();
            for (Comment comment : this.comments) {
                if (comment.getStyle() != commentStyle) continue;
                listBuffer.add(comment);
            }
            return listBuffer.toList();
        }

        static enum Tag {
            DEFAULT,
            NAMED,
            STRING,
            NUMERIC;

        }
    }

    public static interface Comment {
        public String getText();

        public int getSourcePos(int var1);

        public CommentStyle getStyle();

        public boolean isDeprecated();

        public static enum CommentStyle {
            LINE,
            BLOCK,
            JAVADOC;

        }
    }

    public static enum TokenKind implements Formattable,
    Filter<TokenKind>
    {
        EOF,
        ERROR,
        IDENTIFIER(Token.Tag.NAMED),
        ABSTRACT("abstract"),
        ASSERT("assert", Token.Tag.NAMED),
        BOOLEAN("boolean", Token.Tag.NAMED),
        BREAK("break"),
        BYTE("byte", Token.Tag.NAMED),
        CASE("case"),
        CATCH("catch"),
        CHAR("char", Token.Tag.NAMED),
        CLASS("class"),
        CONST("const"),
        CONTINUE("continue"),
        DEFAULT("default"),
        DO("do"),
        DOUBLE("double", Token.Tag.NAMED),
        ELSE("else"),
        ENUM("enum", Token.Tag.NAMED),
        EXTENDS("extends"),
        FINAL("final"),
        FINALLY("finally"),
        FLOAT("float", Token.Tag.NAMED),
        FOR("for"),
        GOTO("goto"),
        IF("if"),
        IMPLEMENTS("implements"),
        IMPORT("import"),
        INSTANCEOF("instanceof"),
        INT("int", Token.Tag.NAMED),
        INTERFACE("interface"),
        LONG("long", Token.Tag.NAMED),
        NATIVE("native"),
        NEW("new"),
        PACKAGE("package"),
        PRIVATE("private"),
        PROTECTED("protected"),
        PUBLIC("public"),
        RETURN("return"),
        SHORT("short", Token.Tag.NAMED),
        STATIC("static"),
        STRICTFP("strictfp"),
        SUPER("super", Token.Tag.NAMED),
        SWITCH("switch"),
        SYNCHRONIZED("synchronized"),
        THIS("this", Token.Tag.NAMED),
        THROW("throw"),
        THROWS("throws"),
        TRANSIENT("transient"),
        TRY("try"),
        VOID("void", Token.Tag.NAMED),
        VOLATILE("volatile"),
        WHILE("while"),
        INTLITERAL(Token.Tag.NUMERIC),
        LONGLITERAL(Token.Tag.NUMERIC),
        FLOATLITERAL(Token.Tag.NUMERIC),
        DOUBLELITERAL(Token.Tag.NUMERIC),
        CHARLITERAL(Token.Tag.NUMERIC),
        STRINGLITERAL(Token.Tag.STRING),
        TRUE("true", Token.Tag.NAMED),
        FALSE("false", Token.Tag.NAMED),
        NULL("null", Token.Tag.NAMED),
        UNDERSCORE("_", Token.Tag.NAMED),
        ARROW("->"),
        COLCOL("::"),
        LPAREN("("),
        RPAREN(")"),
        LBRACE("{"),
        RBRACE("}"),
        LBRACKET("["),
        RBRACKET("]"),
        SEMI(";"),
        COMMA(","),
        DOT("."),
        ELLIPSIS("..."),
        EQ("="),
        GT(">"),
        LT("<"),
        BANG("!"),
        TILDE("~"),
        QUES("?"),
        COLON(":"),
        EQEQ("=="),
        LTEQ("<="),
        GTEQ(">="),
        BANGEQ("!="),
        AMPAMP("&&"),
        BARBAR("||"),
        PLUSPLUS("++"),
        SUBSUB("--"),
        PLUS("+"),
        SUB("-"),
        STAR("*"),
        SLASH("/"),
        AMP("&"),
        BAR("|"),
        CARET("^"),
        PERCENT("%"),
        LTLT("<<"),
        GTGT(">>"),
        GTGTGT(">>>"),
        PLUSEQ("+="),
        SUBEQ("-="),
        STAREQ("*="),
        SLASHEQ("/="),
        AMPEQ("&="),
        BAREQ("|="),
        CARETEQ("^="),
        PERCENTEQ("%="),
        LTLTEQ("<<="),
        GTGTEQ(">>="),
        GTGTGTEQ(">>>="),
        MONKEYS_AT("@"),
        CUSTOM;

        public final String name;
        public final Token.Tag tag;

        private TokenKind() {
            this(null, Token.Tag.DEFAULT);
        }

        private TokenKind(String string2) {
            this(string2, Token.Tag.DEFAULT);
        }

        private TokenKind(Token.Tag tag) {
            this(null, tag);
        }

        private TokenKind(String string2, Token.Tag tag) {
            this.name = string2;
            this.tag = tag;
        }

        public String toString() {
            switch (this) {
                case IDENTIFIER: {
                    return "token.identifier";
                }
                case CHARLITERAL: {
                    return "token.character";
                }
                case STRINGLITERAL: {
                    return "token.string";
                }
                case INTLITERAL: {
                    return "token.integer";
                }
                case LONGLITERAL: {
                    return "token.long-integer";
                }
                case FLOATLITERAL: {
                    return "token.float";
                }
                case DOUBLELITERAL: {
                    return "token.double";
                }
                case ERROR: {
                    return "token.bad-symbol";
                }
                case EOF: {
                    return "token.end-of-input";
                }
                case DOT: 
                case COMMA: 
                case SEMI: 
                case LPAREN: 
                case RPAREN: 
                case LBRACKET: 
                case RBRACKET: 
                case LBRACE: 
                case RBRACE: {
                    return "'" + this.name + "'";
                }
            }
            return this.name;
        }

        @Override
        public String getKind() {
            return "Token";
        }

        @Override
        public String toString(Locale locale, Messages messages) {
            return this.name != null ? this.toString() : messages.getLocalizedString(locale, "compiler.misc." + this.toString(), new Object[0]);
        }

        @Override
        public boolean accepts(TokenKind tokenKind) {
            return this == tokenKind;
        }
    }
}

