/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

public class GraphUtils {
    public static <D, N extends TarjanNode<D, N>> List<? extends List<? extends N>> tarjan(Iterable<? extends N> iterable) {
        ListBuffer<List<N>> listBuffer = new ListBuffer<List<N>>();
        ListBuffer listBuffer2 = new ListBuffer();
        int n = 0;
        for (TarjanNode tarjanNode : iterable) {
            if (tarjanNode.index != -1) continue;
            n += GraphUtils.tarjan(tarjanNode, n, listBuffer2, listBuffer);
        }
        return listBuffer.toList();
    }

    private static <D, N extends TarjanNode<D, N>> int tarjan(N n, int n2, ListBuffer<N> listBuffer, ListBuffer<List<N>> listBuffer2) {
        n.index = n2;
        n.lowlink = n2++;
        listBuffer.prepend(n);
        n.active = true;
        for (Object object : n.getAllDependencies()) {
            if (((TarjanNode)object).index == -1) {
                GraphUtils.tarjan(object, n2, listBuffer, listBuffer2);
                n.lowlink = Math.min(n.lowlink, ((TarjanNode)object).lowlink);
                continue;
            }
            if (!listBuffer.contains(object)) continue;
            n.lowlink = Math.min(n.lowlink, ((TarjanNode)object).index);
        }
        if (n.lowlink == n.index) {
            TarjanNode tarjanNode;
            Object object;
            object = new ListBuffer();
            do {
                tarjanNode = (TarjanNode)listBuffer.remove();
                tarjanNode.active = false;
                ((ListBuffer)object).add(tarjanNode);
            } while (tarjanNode != n);
            listBuffer2.add(((ListBuffer)object).toList());
        }
        return n2;
    }

    public static <D, N extends DottableNode<D, N>> String toDot(Collection<? extends N> collection, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("digraph %s {\n", string));
        stringBuilder.append(String.format("label = %s;\n", DotVisitor.wrap(string2)));
        DotVisitor dotVisitor = new DotVisitor();
        dotVisitor.visit(collection, stringBuilder);
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public static class DotVisitor<D, N extends DottableNode<D, N>>
    extends NodeVisitor<D, N, StringBuilder> {
        @Override
        public void visitDependency(DependencyKind dependencyKind, N n, N n2, StringBuilder stringBuilder) {
            stringBuilder.append(String.format("%s -> %s", n.hashCode(), n2.hashCode()));
            stringBuilder.append(this.formatProperties(n.dependencyAttributes(n2, dependencyKind)));
            stringBuilder.append('\n');
        }

        @Override
        public void visitNode(N n, StringBuilder stringBuilder) {
            stringBuilder.append(String.format("%s ", n.hashCode()));
            stringBuilder.append(this.formatProperties(n.nodeAttributes()));
            stringBuilder.append('\n');
        }

        protected String formatProperties(Properties properties) {
            return properties.toString().replaceAll(",", " ").replaceAll("\\{", "[").replaceAll("\\}", "]");
        }

        protected static String wrap(String string) {
            String string2 = "\"" + string + "\"";
            return string2.replaceAll("\n", "");
        }
    }

    public static abstract class TarjanNode<D, N extends TarjanNode<D, N>>
    extends AbstractNode<D, N>
    implements Comparable<N> {
        int index = -1;
        int lowlink;
        boolean active;

        public TarjanNode(D d) {
            super(d);
        }

        public abstract Iterable<? extends N> getAllDependencies();

        @Override
        public int compareTo(N n) {
            return this.index < ((TarjanNode)n).index ? -1 : (this.index == ((TarjanNode)n).index ? 0 : 1);
        }
    }

    public static abstract class AbstractNode<D, N extends AbstractNode<D, N>>
    implements Node<D, N> {
        public final D data;

        public AbstractNode(D d) {
            this.data = d;
        }

        public abstract DependencyKind[] getSupportedDependencyKinds();

        public abstract Collection<? extends N> getDependenciesByKind(DependencyKind var1);

        public String toString() {
            return this.data.toString();
        }

        @Override
        public <A> void accept(NodeVisitor<D, N, A> nodeVisitor, A a) {
            nodeVisitor.visitNode(this, a);
            for (DependencyKind dependencyKind : this.getSupportedDependencyKinds()) {
                for (AbstractNode abstractNode : new ArrayList<N>(this.getDependenciesByKind(dependencyKind))) {
                    nodeVisitor.visitDependency(dependencyKind, this, abstractNode, a);
                }
            }
        }
    }

    public static interface DottableNode<D, N extends DottableNode<D, N>>
    extends Node<D, N> {
        public Properties nodeAttributes();

        public Properties dependencyAttributes(N var1, DependencyKind var2);
    }

    static abstract class NodeVisitor<D, N extends Node<D, N>, A> {
        NodeVisitor() {
        }

        public abstract void visitNode(N var1, A var2);

        public abstract void visitDependency(DependencyKind var1, N var2, N var3, A var4);

        public void visit(Collection<? extends N> collection, A a) {
            for (Node node : new ArrayList<N>(collection)) {
                node.accept(this, a);
            }
        }
    }

    public static interface Node<D, N extends Node<D, N>> {
        public <A> void accept(NodeVisitor<D, N, A> var1, A var2);
    }

    public static interface DependencyKind {
    }
}

