/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MapFieldLite;
import com.google.protobuf.Message;
import com.google.protobuf.MessageReflection;
import com.google.protobuf.TextFormat;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractMessage
extends AbstractMessageLite
implements Message {
    protected int memoizedSize = -1;

    @Override
    public boolean isInitialized() {
        return MessageReflection.isInitialized(this);
    }

    protected Message.Builder newBuilderForType(BuilderParent builderParent) {
        throw new UnsupportedOperationException("Nested builder is not supported for this type.");
    }

    @Override
    public List<String> findInitializationErrors() {
        return MessageReflection.findMissingFields(this);
    }

    @Override
    public String getInitializationErrorString() {
        return MessageReflection.delimitWithCommas(this.findInitializationErrors());
    }

    @Override
    public boolean hasOneof(Descriptors.OneofDescriptor oneofDescriptor) {
        throw new UnsupportedOperationException("hasOneof() is not implemented.");
    }

    @Override
    public Descriptors.FieldDescriptor getOneofFieldDescriptor(Descriptors.OneofDescriptor oneofDescriptor) {
        throw new UnsupportedOperationException("getOneofFieldDescriptor() is not implemented.");
    }

    @Override
    public final String toString() {
        return TextFormat.printToString(this);
    }

    @Override
    public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        MessageReflection.writeMessageTo(this, this.getAllFields(), codedOutputStream, false);
    }

    @Override
    public int getSerializedSize() {
        int n = this.memoizedSize;
        if (n != -1) {
            return n;
        }
        this.memoizedSize = MessageReflection.getSerializedSize(this, this.getAllFields());
        return this.memoizedSize;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)object;
        if (this.getDescriptorForType() != message.getDescriptorForType()) {
            return false;
        }
        return AbstractMessage.compareFields(this.getAllFields(), message.getAllFields()) && this.getUnknownFields().equals(message.getUnknownFields());
    }

    @Override
    public int hashCode() {
        int n = this.memoizedHashCode;
        if (n == 0) {
            n = 41;
            n = 19 * n + this.getDescriptorForType().hashCode();
            n = AbstractMessage.hashFields(n, this.getAllFields());
            this.memoizedHashCode = n = 29 * n + this.getUnknownFields().hashCode();
        }
        return n;
    }

    private static ByteString toByteString(Object object) {
        if (object instanceof byte[]) {
            return ByteString.copyFrom((byte[])object);
        }
        return (ByteString)object;
    }

    private static boolean compareBytes(Object object, Object object2) {
        if (object instanceof byte[] && object2 instanceof byte[]) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        return AbstractMessage.toByteString(object).equals(AbstractMessage.toByteString(object2));
    }

    private static Map convertMapEntryListToMap(List list) {
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Iterator iterator = list.iterator();
        Message message = (Message)iterator.next();
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName("key");
        Descriptors.FieldDescriptor fieldDescriptor2 = descriptor.findFieldByName("value");
        Object object = message.getField(fieldDescriptor2);
        if (object instanceof Descriptors.EnumValueDescriptor) {
            object = ((Descriptors.EnumValueDescriptor)object).getNumber();
        }
        hashMap.put(message.getField(fieldDescriptor), object);
        while (iterator.hasNext()) {
            message = (Message)iterator.next();
            object = message.getField(fieldDescriptor2);
            if (object instanceof Descriptors.EnumValueDescriptor) {
                object = ((Descriptors.EnumValueDescriptor)object).getNumber();
            }
            hashMap.put(message.getField(fieldDescriptor), object);
        }
        return hashMap;
    }

    private static boolean compareMapField(Object object, Object object2) {
        Map map = AbstractMessage.convertMapEntryListToMap((List)object);
        Map map2 = AbstractMessage.convertMapEntryListToMap((List)object2);
        return MapFieldLite.equals(map, map2);
    }

    static boolean compareFields(Map<Descriptors.FieldDescriptor, Object> map, Map<Descriptors.FieldDescriptor, Object> map2) {
        if (map.size() != map2.size()) {
            return false;
        }
        for (Descriptors.FieldDescriptor fieldDescriptor : map.keySet()) {
            if (!map2.containsKey(fieldDescriptor)) {
                return false;
            }
            Object object = map.get(fieldDescriptor);
            Object object2 = map2.get(fieldDescriptor);
            if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.BYTES) {
                if (fieldDescriptor.isRepeated()) {
                    List list = (List)object;
                    List list2 = (List)object2;
                    if (list.size() != list2.size()) {
                        return false;
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        if (AbstractMessage.compareBytes(list.get(i), list2.get(i))) continue;
                        return false;
                    }
                    continue;
                }
                if (AbstractMessage.compareBytes(object, object2)) continue;
                return false;
            }
            if (!(fieldDescriptor.isMapField() ? !AbstractMessage.compareMapField(object, object2) : !object.equals(object2))) continue;
            return false;
        }
        return true;
    }

    private static int hashMapField(Object object) {
        return MapFieldLite.calculateHashCodeForMap(AbstractMessage.convertMapEntryListToMap((List)object));
    }

    protected static int hashFields(int n, Map<Descriptors.FieldDescriptor, Object> map) {
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : map.entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
            Object object = entry.getValue();
            n = 37 * n + fieldDescriptor.getNumber();
            if (fieldDescriptor.isMapField()) {
                n = 53 * n + AbstractMessage.hashMapField(object);
                continue;
            }
            if (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.ENUM) {
                n = 53 * n + object.hashCode();
                continue;
            }
            if (fieldDescriptor.isRepeated()) {
                List list = (List)object;
                n = 53 * n + Internal.hashEnumList(list);
                continue;
            }
            n = 53 * n + Internal.hashEnum((Internal.EnumLite)object);
        }
        return n;
    }

    @Override
    UninitializedMessageException newUninitializedMessageException() {
        return Builder.newUninitializedMessageException(this);
    }

    @Deprecated
    protected static int hashLong(long l) {
        return (int)(l ^ l >>> 32);
    }

    @Deprecated
    protected static int hashBoolean(boolean bl) {
        return bl ? 1231 : 1237;
    }

    @Deprecated
    protected static int hashEnum(Internal.EnumLite enumLite) {
        return enumLite.getNumber();
    }

    @Deprecated
    protected static int hashEnumList(List<? extends Internal.EnumLite> list) {
        int n = 1;
        for (Internal.EnumLite enumLite : list) {
            n = 31 * n + AbstractMessage.hashEnum(enumLite);
        }
        return n;
    }

    public static abstract class Builder<BuilderType extends Builder<BuilderType>>
    extends AbstractMessageLite.Builder
    implements Message.Builder {
        @Override
        public BuilderType clone() {
            throw new UnsupportedOperationException("clone() should be implemented in subclasses.");
        }

        @Override
        public boolean hasOneof(Descriptors.OneofDescriptor oneofDescriptor) {
            throw new UnsupportedOperationException("hasOneof() is not implemented.");
        }

        @Override
        public Descriptors.FieldDescriptor getOneofFieldDescriptor(Descriptors.OneofDescriptor oneofDescriptor) {
            throw new UnsupportedOperationException("getOneofFieldDescriptor() is not implemented.");
        }

        public BuilderType clearOneof(Descriptors.OneofDescriptor oneofDescriptor) {
            throw new UnsupportedOperationException("clearOneof() is not implemented.");
        }

        public BuilderType clear() {
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : this.getAllFields().entrySet()) {
                this.clearField(entry.getKey());
            }
            return (BuilderType)this;
        }

        @Override
        public List<String> findInitializationErrors() {
            return MessageReflection.findMissingFields(this);
        }

        @Override
        public String getInitializationErrorString() {
            return MessageReflection.delimitWithCommas(this.findInitializationErrors());
        }

        protected BuilderType internalMergeFrom(AbstractMessageLite abstractMessageLite) {
            return (BuilderType)this.mergeFrom((Message)((Object)abstractMessageLite));
        }

        public BuilderType mergeFrom(Message message) {
            if (message.getDescriptorForType() != this.getDescriptorForType()) {
                throw new IllegalArgumentException("mergeFrom(Message) can only merge messages of the same type.");
            }
            for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : message.getAllFields().entrySet()) {
                Descriptors.FieldDescriptor fieldDescriptor = entry.getKey();
                if (fieldDescriptor.isRepeated()) {
                    for (Object e : (List)entry.getValue()) {
                        this.addRepeatedField(fieldDescriptor, e);
                    }
                    continue;
                }
                if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    Message message2 = (Message)this.getField(fieldDescriptor);
                    if (message2 == message2.getDefaultInstanceForType()) {
                        this.setField(fieldDescriptor, entry.getValue());
                        continue;
                    }
                    this.setField(fieldDescriptor, message2.newBuilderForType().mergeFrom(message2).mergeFrom((Message)entry.getValue()).build());
                    continue;
                }
                this.setField(fieldDescriptor, entry.getValue());
            }
            this.mergeUnknownFields(message.getUnknownFields());
            return (BuilderType)this;
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream codedInputStream) throws IOException {
            return (BuilderType)this.mergeFrom(codedInputStream, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        }

        @Override
        public BuilderType mergeFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            int n;
            UnknownFieldSet.Builder builder = UnknownFieldSet.newBuilder(this.getUnknownFields());
            while ((n = codedInputStream.readTag()) != 0) {
                MessageReflection.BuilderAdapter builderAdapter = new MessageReflection.BuilderAdapter(this);
                if (MessageReflection.mergeFieldFrom(codedInputStream, builder, extensionRegistryLite, this.getDescriptorForType(), builderAdapter, n)) continue;
                break;
            }
            this.setUnknownFields(builder.build());
            return (BuilderType)this;
        }

        public BuilderType mergeUnknownFields(UnknownFieldSet unknownFieldSet) {
            this.setUnknownFields(UnknownFieldSet.newBuilder(this.getUnknownFields()).mergeFrom(unknownFieldSet).build());
            return (BuilderType)this;
        }

        @Override
        public Message.Builder getFieldBuilder(Descriptors.FieldDescriptor fieldDescriptor) {
            throw new UnsupportedOperationException("getFieldBuilder() called on an unsupported message type.");
        }

        @Override
        public Message.Builder getRepeatedFieldBuilder(Descriptors.FieldDescriptor fieldDescriptor, int n) {
            throw new UnsupportedOperationException("getRepeatedFieldBuilder() called on an unsupported message type.");
        }

        public String toString() {
            return TextFormat.printToString(this);
        }

        protected static UninitializedMessageException newUninitializedMessageException(Message message) {
            return new UninitializedMessageException(MessageReflection.findMissingFields(message));
        }

        void markClean() {
            throw new IllegalStateException("Should be overridden by subclasses.");
        }

        void dispose() {
            throw new IllegalStateException("Should be overridden by subclasses.");
        }

        @Override
        public BuilderType mergeFrom(ByteString byteString) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byteString));
        }

        @Override
        public BuilderType mergeFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byteString, extensionRegistryLite));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byArray));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray, int n, int n2) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byArray, n, n2));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byArray, extensionRegistryLite));
        }

        @Override
        public BuilderType mergeFrom(byte[] byArray, int n, int n2, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            return (BuilderType)((Builder)super.mergeFrom(byArray, n, n2, extensionRegistryLite));
        }

        @Override
        public BuilderType mergeFrom(InputStream inputStream) throws IOException {
            return (BuilderType)((Builder)super.mergeFrom(inputStream));
        }

        @Override
        public BuilderType mergeFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            return (BuilderType)((Builder)super.mergeFrom(inputStream, extensionRegistryLite));
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream) throws IOException {
            return super.mergeDelimitedFrom(inputStream);
        }

        @Override
        public boolean mergeDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            return super.mergeDelimitedFrom(inputStream, extensionRegistryLite);
        }
    }

    protected static interface BuilderParent {
        public void markDirty();
    }
}

