/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;

@BugPattern(name="URLEqualsHashCode", summary="Creation of a Set/HashSet/HashMap of java.net.URL. equals() and hashCode() of java.net.URL class make blocking internet connections.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class URLEqualsHashCode
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final String URL_CLASS = "java.net.URL";
    private static final Matcher<Tree> TYPE_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{new URLTypeArgumentMatcher("java.util.Set", 0), new URLTypeArgumentMatcher("java.util.Map", 0)});

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (TYPE_MATCHER.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static class URLTypeArgumentMatcher
    implements Matcher<Tree> {
        private final String clazz;
        private final int typeArgumentIndex;

        URLTypeArgumentMatcher(String clazz, int index) {
            this.clazz = clazz;
            this.typeArgumentIndex = index;
        }

        public boolean matches(Tree tree, VisitorState state) {
            Symbol sym = state.getSymbolFromString(this.clazz);
            if (sym == null) {
                return false;
            }
            Type type = ASTHelpers.getType((Tree)tree);
            if (!ASTHelpers.isSubtype((Type)type, (Type)sym.type, (VisitorState)state)) {
                return false;
            }
            Types types = state.getTypes();
            Type superType = types.asSuper(type, sym);
            if (superType == null) {
                return false;
            }
            List<Type> typeArguments = superType.getTypeArguments();
            if (typeArguments.isEmpty()) {
                return false;
            }
            return ASTHelpers.isSameType((Type)((Type)typeArguments.get(this.typeArgumentIndex)), (Type)state.getTypeFromString(URLEqualsHashCode.URL_CLASS), (VisitorState)state);
        }
    }
}

