/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableAnalysis;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableAnnotationInfo;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;

@BugPattern(name="Immutable", summary="Type declaration annotated with @Immutable is not immutable", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class ImmutableChecker
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree tree, VisitorState state) {
        ImmutableAnalysis analysis = new ImmutableAnalysis(this, state, "@Immutable classes cannot have non-final fields", "@Immutable class has mutable field");
        if (tree.getSimpleName().length() == 0) {
            return this.handleAnonymousClass(tree, state, analysis);
        }
        ImmutableAnnotationInfo annotation = ImmutableAnalysis.getImmutableAnnotation(tree);
        if (annotation == null) {
            return this.checkSubtype(tree, state);
        }
        if (WellKnownMutability.KNOWN_IMMUTABLE.containsValue((Object)annotation)) {
            return Description.NO_MATCH;
        }
        HashSet<String> typarams = new HashSet<String>();
        for (TypeParameterTree typeParameterTree : tree.getTypeParameters()) {
            typarams.add(typeParameterTree.getName().toString());
        }
        Sets.SetView difference = Sets.difference(annotation.containerOf(), typarams);
        if (!difference.isEmpty()) {
            String string = String.format("could not find type(s) referenced by containerOf: %s", Joiner.on((String)"', '").join((Iterable)difference));
            return this.buildDescription(tree).setMessage(string).build();
        }
        ImmutableAnalysis.Violation violation = analysis.checkForImmutability((Optional<ClassTree>)Optional.of((Object)tree), ImmutableChecker.immutableTypeParametersInScope(ASTHelpers.getSymbol((ClassTree)tree)), ASTHelpers.getType((ClassTree)tree));
        if (!violation.isPresent()) {
            return Description.NO_MATCH;
        }
        String message = "type annotated with @Immutable could not be proven immutable: " + violation.message();
        return this.buildDescription(tree).setMessage(message).build();
    }

    private Description handleAnonymousClass(ClassTree tree, VisitorState state, ImmutableAnalysis analysis) {
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol((ClassTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        Type superType = ImmutableChecker.immutableSupertype(sym, state);
        if (superType == null) {
            return Description.NO_MATCH;
        }
        ImmutableSet<String> typarams = ImmutableChecker.immutableTypeParametersInScope(sym);
        ImmutableAnalysis.Violation info = analysis.areFieldsImmutable((Optional<ClassTree>)Optional.of((Object)tree), typarams, ASTHelpers.getType((ClassTree)tree));
        if (!info.isPresent()) {
            return Description.NO_MATCH;
        }
        String reason = Joiner.on((String)", ").join(info.path());
        String message = String.format("Class extends @Immutable type %s, but is not immutable: %s", superType, reason);
        return this.buildDescription(tree).setMessage(message).build();
    }

    private Description checkSubtype(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol((ClassTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        Type superType = ImmutableChecker.immutableSupertype(sym, state);
        if (superType == null) {
            return Description.NO_MATCH;
        }
        String message = String.format("Class extends @Immutable type %s, but is not annotated as immutable", superType);
        SuggestedFix fix = SuggestedFix.builder().prefixWith((Tree)tree, "@Immutable ").addImport(Immutable.class.getName()).build();
        return this.buildDescription(tree).setMessage(message).addFix((Fix)fix).build();
    }

    private static Type immutableSupertype(Symbol sym, VisitorState state) {
        for (Type superType : state.getTypes().closure(sym.type)) {
            if (superType.equals(sym.type) || !ASTHelpers.hasAnnotation((Symbol)superType.tsym, Immutable.class, (VisitorState)state)) continue;
            return superType;
        }
        return null;
    }

    private static ImmutableSet<String> immutableTypeParametersInScope(Symbol sym) {
        if (sym == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        Symbol s = sym;
        block4: while (s.owner != null) {
            switch (s.getKind()) {
                case INSTANCE_INIT: {
                    break;
                }
                case PACKAGE: {
                    break block4;
                }
                default: {
                    ImmutableAnnotationInfo annotation = ImmutableAnalysis.getImmutableAnnotation(s);
                    if (annotation == null) break;
                    for (Symbol.TypeVariableSymbol typaram : s.getTypeParameters()) {
                        String name = ((Name)typaram.getSimpleName()).toString();
                        if (!annotation.containerOf().contains((Object)name)) continue;
                        result.add((Object)name);
                    }
                    if (s.isStatic()) break block4;
                }
            }
            s = s.owner;
        }
        return result.build();
    }
}

