/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Predicate;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugCheckerInfo;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.ErrorProneAnalyzer;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.RefactoringCollection;
import com.google.errorprone.scanner.ErrorProneScannerTransformer;
import com.google.errorprone.scanner.Scanner;
import com.google.errorprone.scanner.ScannerSupplier;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacMessages;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

public class BaseErrorProneJavaCompiler
implements JavaCompiler {
    private final JavaCompiler javacTool;
    private final ScannerSupplier scannerSupplier;

    public BaseErrorProneJavaCompiler(ScannerSupplier scannerSupplier) {
        this(JavacTool.create(), scannerSupplier);
    }

    BaseErrorProneJavaCompiler(JavaCompiler javacTool, ScannerSupplier scannerSupplier) {
        this.javacTool = javacTool;
        this.scannerSupplier = scannerSupplier;
    }

    @Override
    public JavaCompiler.CompilationTask getTask(final Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits) {
        ErrorProneOptions errorProneOptions = ErrorProneOptions.processArgs(options);
        List<String> remainingOptions = Arrays.asList(errorProneOptions.getRemainingArgs());
        ImmutableList<String> javacOpts = ImmutableList.copyOf(remainingOptions);
        javacOpts = BaseErrorProneJavaCompiler.defaultToLatestSupportedLanguageLevel(javacOpts);
        javacOpts = BaseErrorProneJavaCompiler.setCompilePolicyToByFile(javacOpts);
        final JavacTaskImpl task = (JavacTaskImpl)this.javacTool.getTask(out, fileManager, diagnosticListener, (Iterable<String>)javacOpts, classes, compilationUnits);
        BaseErrorProneJavaCompiler.setupMessageBundle(task.getContext());
        final RefactoringCollection[] refactoringCollection = new RefactoringCollection[]{null};
        task.addTaskListener(this.createAnalyzer(errorProneOptions, task.getContext(), refactoringCollection));
        return new JavaCompiler.CompilationTask(){

            @Override
            public void setProcessors(Iterable<? extends Processor> processors) {
                task.setProcessors(processors);
            }

            @Override
            public void setLocale(Locale locale) {
                task.setLocale(locale);
            }

            @Override
            public Boolean call() {
                return BaseErrorProneJavaCompiler.wrapPotentialRefactoringCall(task.call(), new PrintWriter(out, true), refactoringCollection[0]);
            }
        };
    }

    @Override
    public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        return this.javacTool.getStandardFileManager(diagnosticListener, locale, charset);
    }

    @Override
    public int isSupportedOption(String option) {
        int numberOfArgs = this.javacTool.isSupportedOption(option);
        if (numberOfArgs != -1) {
            return numberOfArgs;
        }
        return ErrorProneOptions.isSupportedOption(option);
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        return this.javacTool.run(in, out, err, arguments);
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        EnumSet<SourceVersion> filtered = EnumSet.noneOf(SourceVersion.class);
        for (SourceVersion version : this.javacTool.getSourceVersions()) {
            if (version.compareTo(SourceVersion.RELEASE_6) < 0) continue;
            filtered.add(version);
        }
        return filtered;
    }

    private static ImmutableList<String> defaultToLatestSupportedLanguageLevel(ImmutableList<String> args) {
        String overrideLanguageLevel;
        switch (StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value()) {
            case "1.7": {
                overrideLanguageLevel = "7";
                break;
            }
            case "1.8": {
                overrideLanguageLevel = "8";
                break;
            }
            default: {
                return args;
            }
        }
        return ImmutableList.builder().add((Object[])new String[]{"-Xlint:-options", "-source", overrideLanguageLevel, "-target", overrideLanguageLevel}).addAll(args).build();
    }

    private static ImmutableList<String> setCompilePolicyToByFile(ImmutableList<String> args) {
        for (String arg : args) {
            String value;
            if (!arg.startsWith("-XDcompilePolicy")) continue;
            switch (value = arg.substring(arg.indexOf(61) + 1)) {
                case "byfile": 
                case "simple": {
                    break;
                }
                default: {
                    throw new InvalidCommandLineOptionException(String.format("-XDcompilePolicy=%s is not supported by Error Prone", value));
                }
            }
            return args;
        }
        return ImmutableList.builder().addAll(args).add((Object)"-XDcompilePolicy=byfile").build();
    }

    public static void setupMessageBundle(Context context) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.google.errorprone.errors");
        JavacMessages.instance(context).add(l -> bundle);
    }

    private ErrorProneAnalyzer createAnalyzer(ErrorProneOptions epOptions, Context context, RefactoringCollection[] refactoringCollection) {
        if (!epOptions.patchingOptions().doRefactor()) {
            return ErrorProneAnalyzer.createByScanningForPlugins(this.scannerSupplier, epOptions, context);
        }
        refactoringCollection[0] = RefactoringCollection.refactor(epOptions.patchingOptions());
        CodeTransformer codeTransformer = (CodeTransformer)((Supplier)epOptions.patchingOptions().customRefactorer().or(() -> {
            ScannerSupplier toUse = this.scannerSupplier;
            Set<String> namedCheckers = epOptions.patchingOptions().namedCheckers();
            if (!namedCheckers.isEmpty()) {
                toUse = this.scannerSupplier.filter((Predicate<? super BugCheckerInfo>)((Predicate)bci -> namedCheckers.contains(bci.canonicalName())));
            }
            return ErrorProneScannerTransformer.create((Scanner)toUse.applyOverrides(epOptions).get());
        })).get();
        return ErrorProneAnalyzer.createWithCustomDescriptionListener(codeTransformer, epOptions, context, refactoringCollection[0]);
    }

    private static boolean wrapPotentialRefactoringCall(boolean original, PrintWriter errOutput, @Nullable RefactoringCollection refactoringCollection) {
        if (refactoringCollection == null) {
            return original;
        }
        try {
            RefactoringCollection.RefactoringResult refactoringResult = refactoringCollection.applyChanges();
            if (refactoringResult.type() == RefactoringCollection.RefactoringResultType.CHANGED) {
                errOutput.println(refactoringResult.message());
                errOutput.flush();
            }
            return original;
        }
        catch (Exception e) {
            errOutput.append(e.getMessage());
            errOutput.flush();
            return false;
        }
    }
}

