/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.turbine.bytecode.AnnotationWriter;
import com.google.turbine.bytecode.Attribute;
import com.google.turbine.bytecode.ClassFile;
import com.google.turbine.bytecode.ConstantPool;
import com.google.turbine.model.Const;
import java.util.List;

public class AttributeWriter {
    private final ConstantPool pool;
    private final ByteArrayDataOutput output;

    public AttributeWriter(ConstantPool pool, ByteArrayDataOutput output) {
        this.pool = pool;
        this.output = output;
    }

    public void write(Attribute attribute) {
        switch (attribute.kind()) {
            case SIGNATURE: {
                this.writeSignatureAttribute((Attribute.Signature)attribute);
                break;
            }
            case EXCEPTIONS: {
                this.writeExceptionsAttribute((Attribute.ExceptionsAttribute)attribute);
                break;
            }
            case INNER_CLASSES: {
                this.writeInnerClasses((Attribute.InnerClasses)attribute);
                break;
            }
            case CONSTANT_VALUE: {
                this.writeConstantValue((Attribute.ConstantValue)attribute);
                break;
            }
            case RUNTIME_VISIBLE_ANNOTATIONS: 
            case RUNTIME_INVISIBLE_ANNOTATIONS: {
                this.writeAnnotation((Attribute.Annotations)attribute);
                break;
            }
            case ANNOTATION_DEFAULT: {
                this.writeAnnotationDefault((Attribute.AnnotationDefault)attribute);
                break;
            }
            case RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS: 
            case RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS: {
                this.writeParameterAnnotations((Attribute.ParameterAnnotations)attribute);
                break;
            }
            case DEPRECATED: {
                this.writeDeprecated(attribute);
                break;
            }
            case RUNTIME_INVISIBLE_TYPE_ANNOTATIONS: 
            case RUNTIME_VISIBLE_TYPE_ANNOTATIONS: {
                this.writeTypeAnnotation((Attribute.TypeAnnotations)attribute);
                break;
            }
            case METHOD_PARAMETERS: {
                this.writeMethodParameters((Attribute.MethodParameters)attribute);
                break;
            }
            default: {
                throw new AssertionError((Object)attribute.kind());
            }
        }
    }

    private void writeInnerClasses(Attribute.InnerClasses attribute) {
        this.output.writeShort((int)this.pool.utf8(attribute.kind().signature()));
        this.output.writeInt(attribute.inners.size() * 8 + 2);
        this.output.writeShort(attribute.inners.size());
        for (ClassFile.InnerClass inner : attribute.inners) {
            this.output.writeShort((int)this.pool.classInfo(inner.innerClass()));
            this.output.writeShort((int)this.pool.classInfo(inner.outerClass()));
            this.output.writeShort((int)this.pool.utf8(inner.innerName()));
            this.output.writeShort(inner.access());
        }
    }

    private void writeExceptionsAttribute(Attribute.ExceptionsAttribute attribute) {
        this.output.writeShort((int)this.pool.utf8(attribute.kind().signature()));
        this.output.writeInt(2 + attribute.exceptions.size() * 2);
        this.output.writeShort(attribute.exceptions.size());
        for (String exception : attribute.exceptions) {
            this.output.writeShort((int)this.pool.classInfo(exception));
        }
    }

    private void writeSignatureAttribute(Attribute.Signature attribute) {
        this.output.writeShort((int)this.pool.utf8(attribute.kind().signature()));
        this.output.writeInt(2);
        this.output.writeShort((int)this.pool.utf8(attribute.signature));
    }

    public void writeConstantValue(Attribute.ConstantValue attribute) {
        this.output.writeShort((int)this.pool.utf8(attribute.kind().signature()));
        this.output.writeInt(2);
        Const.Value value = attribute.value;
        switch (value.constantTypeKind()) {
            case INT: 
            case CHAR: 
            case SHORT: 
            case BYTE: {
                this.output.writeShort((int)this.pool.integer(value.asInteger().value()));
                break;
            }
            case LONG: {
                this.output.writeShort((int)this.pool.longInfo(value.asLong().value()));
                break;
            }
            case DOUBLE: {
                this.output.writeShort((int)this.pool.doubleInfo(value.asDouble().value()));
                break;
            }
            case FLOAT: {
                this.output.writeShort((int)this.pool.floatInfo(value.asFloat().value()));
                break;
            }
            case BOOLEAN: {
                this.output.writeShort((int)this.pool.integer(value.asBoolean().value() ? 1 : 0));
                break;
            }
            case STRING: {
                this.output.writeShort((int)this.pool.string(value.asString().value()));
                break;
            }
            default: {
                throw new AssertionError((Object)value.constantTypeKind());
            }
        }
    }

    public void writeAnnotation(Attribute.Annotations attribute) {
        this.output.writeShort((int)this.pool.utf8(attribute.kind().signature()));
        ByteArrayDataOutput tmp = ByteStreams.newDataOutput();
        tmp.writeShort(attribute.annotations().size());
        for (ClassFile.AnnotationInfo annotation : attribute.annotations()) {
            new AnnotationWriter(this.pool, tmp).writeAnnotation(annotation);
        }
        byte[] data = tmp.toByteArray();
        this.output.writeInt(data.length);
        this.output.write(data);
    }

    public void writeAnnotationDefault(Attribute.AnnotationDefault attribute) {
        this.output.writeShort((int)this.pool.utf8(attribute.kind().signature()));
        ByteArrayDataOutput tmp = ByteStreams.newDataOutput();
        new AnnotationWriter(this.pool, tmp).writeElementValue(attribute.value());
        byte[] data = tmp.toByteArray();
        this.output.writeInt(data.length);
        this.output.write(data);
    }

    public void writeParameterAnnotations(Attribute.ParameterAnnotations attribute) {
        this.output.writeShort((int)this.pool.utf8(attribute.kind().signature()));
        ByteArrayDataOutput tmp = ByteStreams.newDataOutput();
        tmp.writeByte(attribute.annotations().size());
        for (List<ClassFile.AnnotationInfo> parameterAnnotations : attribute.annotations()) {
            tmp.writeShort(parameterAnnotations.size());
            for (ClassFile.AnnotationInfo annotation : parameterAnnotations) {
                new AnnotationWriter(this.pool, tmp).writeAnnotation(annotation);
            }
        }
        byte[] data = tmp.toByteArray();
        this.output.writeInt(data.length);
        this.output.write(data);
    }

    private void writeDeprecated(Attribute attribute) {
        this.output.writeShort((int)this.pool.utf8(attribute.kind().signature()));
        this.output.writeInt(0);
    }

    private void writeTypeAnnotation(Attribute.TypeAnnotations attribute) {
        this.output.writeShort((int)this.pool.utf8(attribute.kind().signature()));
        ByteArrayDataOutput tmp = ByteStreams.newDataOutput();
        tmp.writeShort(attribute.annotations().size());
        for (ClassFile.TypeAnnotationInfo annotation : attribute.annotations()) {
            new AnnotationWriter(this.pool, tmp).writeTypeAnnotation(annotation);
        }
        byte[] data = tmp.toByteArray();
        this.output.writeInt(data.length);
        this.output.write(data);
    }

    private void writeMethodParameters(Attribute.MethodParameters attribute) {
        this.output.writeShort((int)this.pool.utf8(attribute.kind().signature()));
        this.output.writeInt(attribute.parameters().size() * 4 + 1);
        this.output.writeByte(attribute.parameters().size());
        for (ClassFile.MethodInfo.ParameterInfo parameter : attribute.parameters()) {
            this.output.writeShort(parameter.name() != null ? (int)this.pool.utf8(parameter.name()) : 0);
            this.output.writeShort(parameter.access());
        }
    }
}

