/*
 * Copyright 2013-present Facebook, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package com.facebook.buck.apple.xcode.xcodeproj;

import com.facebook.buck.apple.xcode.XcodeprojSerializer;
import com.google.common.base.Preconditions;

/**
 * Element of the {@link PBXTarget#dependencies}. Represents a dependency of one target upon another
 * target.
 */
public class PBXTargetDependency extends PBXProjectItem {
  private final PBXContainerItemProxy targetProxy;

  public PBXTargetDependency(PBXContainerItemProxy targetProxy) {
    this.targetProxy = Preconditions.checkNotNull(targetProxy);
  }

  @Override
  public String isa() {
    return "PBXTargetDependency";
  }

  public PBXContainerItemProxy getTargetProxy() {
    return targetProxy;
  }

  @Override
  public int stableHash() {
    return targetProxy.stableHash();
  }

  @Override
  public void serializeInto(XcodeprojSerializer s) {
    super.serializeInto(s);

    s.addField("targetProxy", getTargetProxy());
  }
}
