/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.block.ConditionalBlock;
import org.checkerframework.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.dataflow.cfg.block.RegularBlock;
import org.checkerframework.dataflow.cfg.block.SingleSuccessorBlock;
import org.checkerframework.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.dataflow.cfg.node.Node;

public class CFGDOTVisualizer {
    public static String visualize(ControlFlowGraph cfg, Block entry) {
        return CFGDOTVisualizer.visualize(cfg, entry, null, false);
    }

    public static <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> String visualize(ControlFlowGraph cfg, Block entry, Analysis<A, S, T> analysis, boolean verbose) {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        HashSet<Block> visited = new HashSet<Block>();
        LinkedList<Block> worklist = new LinkedList<Block>();
        Block cur = entry;
        visited.add(entry);
        sb1.append("digraph {\n");
        sb1.append("    node [shape=rectangle];\n\n");
        while (cur != null) {
            if (cur.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                ConditionalBlock ccur = (ConditionalBlock)cur;
                Block thenSuccessor = ccur.getThenSuccessor();
                sb2.append("    " + ccur.getId() + " -> " + thenSuccessor.getId());
                sb2.append(" [label=\"then\\n" + (Object)((Object)ccur.getThenFlowRule()) + "\"];\n");
                if (!visited.contains(thenSuccessor)) {
                    visited.add(thenSuccessor);
                    worklist.add(thenSuccessor);
                }
                Block block = ccur.getElseSuccessor();
                sb2.append("    " + ccur.getId() + " -> " + block.getId());
                sb2.append(" [label=\"else\\n" + (Object)((Object)ccur.getElseFlowRule()) + "\"];\n");
                if (!visited.contains(block)) {
                    visited.add(block);
                    worklist.add(block);
                }
            } else {
                assert (cur instanceof SingleSuccessorBlock);
                Block b = ((SingleSuccessorBlock)cur).getSuccessor();
                if (b != null) {
                    sb2.append("    " + cur.getId() + " -> " + b.getId());
                    sb2.append(" [label=\"" + (Object)((Object)((SingleSuccessorBlock)cur).getFlowRule()) + "\"];\n");
                    if (!visited.contains(b)) {
                        visited.add(b);
                        worklist.add(b);
                    }
                }
            }
            if (cur.getType() == Block.BlockType.EXCEPTION_BLOCK) {
                ExceptionBlock ecur = (ExceptionBlock)cur;
                for (Map.Entry entry2 : ecur.getExceptionalSuccessors().entrySet()) {
                    Set blocks = (Set)entry2.getValue();
                    TypeMirror cause = (TypeMirror)entry2.getKey();
                    String exception = cause.toString();
                    if (exception.startsWith("java.lang.")) {
                        exception = exception.replace("java.lang.", "");
                    }
                    for (Block b : blocks) {
                        sb2.append("    " + cur.getId() + " -> " + b.getId());
                        sb2.append(" [label=\"" + exception + "\"];\n");
                        if (visited.contains(b)) continue;
                        visited.add(b);
                        worklist.add(b);
                    }
                }
            }
            cur = (Block)worklist.poll();
        }
        IdentityHashMap<Block, List<Integer>> processOrder = CFGDOTVisualizer.getProcessOrder(cfg);
        for (Block block : visited) {
            sb1.append("    " + block.getId() + " [");
            if (block.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                sb1.append("shape=polygon sides=8 ");
            } else if (block.getType() == Block.BlockType.SPECIAL_BLOCK) {
                sb1.append("shape=oval ");
            }
            sb1.append("label=\"");
            if (verbose) {
                sb1.append("Process order: " + processOrder.get(block).toString().replaceAll("[\\[\\]]", "") + "\\n");
            }
            sb1.append(CFGDOTVisualizer.visualizeContent(block, analysis, verbose).replace("\\n", "\\l") + " \",];\n");
        }
        sb1.append("\n");
        sb1.append((CharSequence)sb2);
        sb1.append("}\n");
        return sb1.toString();
    }

    private static IdentityHashMap<Block, List<Integer>> getProcessOrder(ControlFlowGraph cfg) {
        IdentityHashMap<Block, List<Integer>> depthFirstOrder = new IdentityHashMap<Block, List<Integer>>();
        int count = 1;
        for (Block b : cfg.getDepthFirstOrderedBlocks()) {
            if (depthFirstOrder.get(b) == null) {
                depthFirstOrder.put(b, new ArrayList());
            }
            depthFirstOrder.get(b).add(count++);
        }
        return depthFirstOrder;
    }

    protected static <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> String visualizeContent(Block bb, Analysis<A, S, T> analysis, boolean verbose) {
        StringBuilder sb = new StringBuilder();
        LinkedList<Node> contents = new LinkedList<Node>();
        switch (bb.getType()) {
            case REGULAR_BLOCK: {
                contents.addAll(((RegularBlock)bb).getContents());
                break;
            }
            case EXCEPTION_BLOCK: {
                contents.add(((ExceptionBlock)bb).getNode());
                break;
            }
            case CONDITIONAL_BLOCK: {
                break;
            }
            case SPECIAL_BLOCK: {
                break;
            }
            default: {
                assert (false) : "All types of basic blocks covered";
                break;
            }
        }
        boolean notFirst = false;
        for (Node t : contents) {
            if (notFirst) {
                sb.append("\\n");
            }
            notFirst = true;
            sb.append(CFGDOTVisualizer.prepareString(CFGDOTVisualizer.visualizeNode(t, analysis)));
        }
        boolean centered = false;
        if (sb.length() == 0) {
            centered = true;
            if (bb.getType() == Block.BlockType.SPECIAL_BLOCK) {
                SpecialBlock sbb = (SpecialBlock)bb;
                switch (sbb.getSpecialType()) {
                    case ENTRY: {
                        sb.append("<entry>");
                        break;
                    }
                    case EXIT: {
                        sb.append("<exit>");
                        break;
                    }
                    case EXCEPTIONAL_EXIT: {
                        sb.append("<exceptional-exit>");
                    }
                }
            } else {
                if (bb.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                    return "";
                }
                return "?? empty ??";
            }
        }
        if (analysis != null) {
            TransferInput<A, S> input = analysis.getInput(bb);
            StringBuilder sb2 = new StringBuilder();
            String s = input.toDOToutput().replace("}, else={", "}\\nelse={");
            sb2.append("Before:");
            sb2.append(s.subSequence(1, s.length() - 1));
            sb2.append("\\n~~~~~~~~~\\n");
            sb2.append((CharSequence)sb);
            sb = sb2;
            if (verbose) {
                Node lastNode = null;
                switch (bb.getType()) {
                    case REGULAR_BLOCK: {
                        List<Node> blockContents = ((RegularBlock)bb).getContents();
                        lastNode = (Node)contents.get(blockContents.size() - 1);
                        break;
                    }
                    case EXCEPTION_BLOCK: {
                        lastNode = ((ExceptionBlock)bb).getNode();
                    }
                }
                if (lastNode != null) {
                    sb2.append("\\n~~~~~~~~~\\n");
                    s = analysis.getResult().getStoreAfter(lastNode.getTree()).toDOToutput().replace("}, else={", "}\\nelse={");
                    sb2.append("After:");
                    sb2.append(s);
                }
            }
        }
        return sb.toString() + (centered ? "" : "\\n");
    }

    protected static <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> String visualizeNode(Node t, Analysis<A, S, T> analysis) {
        A value = analysis.getValue(t);
        String valueInfo = "";
        if (value != null) {
            valueInfo = "    > " + value.toString();
        }
        return t.toString() + "   [ " + CFGDOTVisualizer.visualizeType(t) + " ]" + valueInfo;
    }

    protected static String visualizeType(Node t) {
        String name = t.getClass().getSimpleName();
        return name.replace("Node", "");
    }

    protected static String prepareString(String s) {
        return s.replace("\"", "\\\"");
    }
}

