/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.client.MapAllPartitionsClientRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.security.Permission;
import java.util.Map;

public class MapExecuteOnAllKeysRequest
extends MapAllPartitionsClientRequest
implements Portable,
SecureRequest {
    private EntryProcessor processor;

    public MapExecuteOnAllKeysRequest() {
    }

    public MapExecuteOnAllKeysRequest(String name, EntryProcessor processor) {
        super(name);
        this.processor = processor;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return this.getOperationProvider().createPartitionWideEntryOperationFactory(this.name, this.processor);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        MapEntries result = new MapEntries();
        MapService mapService = (MapService)this.getService();
        for (Object o : map.values()) {
            if (o == null) continue;
            MapEntries mapEntries = (MapEntries)mapService.getMapServiceContext().toObject(o);
            for (Map.Entry<Data, Data> entry : mapEntries) {
                result.add(entry);
            }
        }
        return result;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 39;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeObject(this.processor);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        ObjectDataInput in = reader.getRawDataInput();
        this.processor = (EntryProcessor)in.readObject();
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "put", "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "executeOnEntries";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.processor};
    }
}

