/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl.operations;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.spi.UrgentSystemOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.impl.IsStillRunningService;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import java.io.IOException;

public class IsStillExecutingOperation
extends AbstractOperation
implements UrgentSystemOperation,
ReadonlyOperation {
    private long operationCallId;
    private int operationPartitionId;

    public IsStillExecutingOperation() {
    }

    public IsStillExecutingOperation(long operationCallId, int operationPartitionId) {
        this.operationCallId = operationCallId;
        this.operationPartitionId = operationPartitionId;
    }

    @Override
    public void run() throws Exception {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        OperationServiceImpl operationService = (OperationServiceImpl)nodeEngine.getOperationService();
        IsStillRunningService isStillRunningService = operationService.getIsStillRunningService();
        boolean executing = isStillRunningService.isOperationExecuting(this.getCallerAddress(), this.operationPartitionId, this.operationCallId);
        this.getOperationResponseHandler().sendResponse(this, executing);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.operationCallId = in.readLong();
        this.operationPartitionId = in.readInt();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.operationCallId);
        out.writeInt(this.operationPartitionId);
    }
}

