/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.ImmutableCollections;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Optional;
import java.util.function.Predicate;
import javax.lang.model.element.Modifier;

@BugPattern(name="MutableMethodReturnType", category=BugPattern.Category.JDK, summary="Method return type should use the immutable type (such as ImmutableList) instead of the general collection interface type (such as List)", severity=BugPattern.SeverityLevel.WARNING)
public final class MutableMethodReturnType
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<MethodTree> ANNOTATED_WITH_PRODUCES_OR_PROVIDES = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasAnnotation((String)"dagger.Provides"), Matchers.hasAnnotation((String)"dagger.producers.Produces")});
    private static final SimpleTreeVisitor<Tree, Void> GET_TYPE_TREE_VISITOR = new SimpleTreeVisitor<Tree, Void>(){

        @Override
        public Tree visitIdentifier(IdentifierTree tree, Void unused) {
            return tree;
        }

        @Override
        public Tree visitParameterizedType(ParameterizedTypeTree tree, Void unused) {
            return tree.getType();
        }
    };

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)methodTree);
        if (methodSymbol.isConstructor()) {
            return Description.NO_MATCH;
        }
        if (MutableMethodReturnType.isMethodCanBeOverridden(methodSymbol, state)) {
            return Description.NO_MATCH;
        }
        if (ANNOTATED_WITH_PRODUCES_OR_PROVIDES.matches((Tree)methodTree, state)) {
            return Description.NO_MATCH;
        }
        Type returnType = methodSymbol.getReturnType();
        if (ImmutableCollections.isImmutableType(returnType)) {
            return Description.NO_MATCH;
        }
        ImmutableSet<Type.ClassType> returnStatementsTypes = MutableMethodReturnType.getMethodReturnTypes(methodTree);
        if (returnStatementsTypes.isEmpty()) {
            return Description.NO_MATCH;
        }
        boolean alwaysReturnsImmutableType = returnStatementsTypes.stream().allMatch(ImmutableCollections::isImmutableType);
        if (!alwaysReturnsImmutableType) {
            return Description.NO_MATCH;
        }
        Optional<String> immutableReturnType = ImmutableCollections.mutableToImmutable(MutableMethodReturnType.getTypeQualifiedName(returnType));
        if (!immutableReturnType.isPresent()) {
            immutableReturnType = MutableMethodReturnType.getCommonImmutableTypeForAllReturnStatementsTypes(returnStatementsTypes);
        }
        if (!immutableReturnType.isPresent()) {
            return Description.NO_MATCH;
        }
        Type newReturnType = state.getTypeFromString(immutableReturnType.get());
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        fixBuilder.replace(MutableMethodReturnType.getTypeTree(methodTree.getReturnType()), SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fixBuilder, (Symbol)newReturnType.asElement()));
        SuggestedFix fix = fixBuilder.build();
        return this.describeMatch(methodTree.getReturnType(), (Fix)fix);
    }

    private static boolean isMethodCanBeOverridden(Symbol.MethodSymbol methodSymbol, VisitorState state) {
        if (methodSymbol.isStatic() || methodSymbol.isPrivate() || MutableMethodReturnType.isFinalMethod(methodSymbol)) {
            return false;
        }
        ClassTree enclosingClassTree = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
        boolean isEnclosingClassFinal = MutableMethodReturnType.isFinalClass(enclosingClassTree);
        return !isEnclosingClassFinal;
    }

    private static boolean isFinalClass(ClassTree classTree) {
        return classTree.getModifiers().getFlags().contains((Object)Modifier.FINAL);
    }

    private static boolean isFinalMethod(Symbol.MethodSymbol methodSymbol) {
        return (methodSymbol.flags() & 0x10L) == 16L;
    }

    private static Optional<String> getCommonImmutableTypeForAllReturnStatementsTypes(ImmutableSet<Type.ClassType> returnStatementsTypes) {
        Preconditions.checkState((!returnStatementsTypes.isEmpty() ? 1 : 0) != 0);
        Type.ClassType arbitraryClassType = (Type.ClassType)returnStatementsTypes.asList().get(0);
        ImmutableList<String> superTypes = MutableMethodReturnType.getImmutableSuperTypesForClassType(arbitraryClassType);
        return superTypes.stream().filter(MutableMethodReturnType.areAllReturnStatementsAssignable(returnStatementsTypes)).findFirst();
    }

    private static Predicate<String> areAllReturnStatementsAssignable(ImmutableSet<Type.ClassType> returnStatementsTypes) {
        return s -> returnStatementsTypes.stream().map(MutableMethodReturnType::getImmutableSuperTypesForClassType).allMatch(c -> c.contains(s));
    }

    private static ImmutableList<String> getImmutableSuperTypesForClassType(Type.ClassType classType) {
        ImmutableList.Builder immutableSuperTypes = ImmutableList.builder();
        Type.ClassType superType = classType;
        while (superType.supertype_field instanceof Type.ClassType) {
            if (ImmutableCollections.isImmutableType(superType)) {
                immutableSuperTypes.add((Object)MutableMethodReturnType.getTypeQualifiedName(((Symbol.TypeSymbol)superType.asElement()).type));
            }
            superType = (Type.ClassType)superType.supertype_field;
        }
        return immutableSuperTypes.build();
    }

    private static String getTypeQualifiedName(Type type) {
        return type.tsym.getQualifiedName().toString();
    }

    private static ImmutableSet<Type.ClassType> getMethodReturnTypes(MethodTree methodTree) {
        final ImmutableSet.Builder returnTypes = ImmutableSet.builder();
        methodTree.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitReturn(ReturnTree node, Void unused) {
                Type type = ASTHelpers.getType((Tree)node.getExpression());
                if (type instanceof Type.ClassType) {
                    returnTypes.add((Object)((Type.ClassType)type));
                }
                return null;
            }
        }, null);
        return returnTypes.build();
    }

    private static Tree getTypeTree(Tree tree) {
        return tree.accept(GET_TYPE_TREE_VISITOR, null);
    }
}

