/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.guice;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="ProvidesMethodOutsideOfModule", summary="@Provides methods need to be declared in a Module to have any effect.", explanation="Guice `@Provides` methods annotate methods that are used as a means of declaring bindings. However, this is only helpful inside of a module. Methods outside of these modules are not used for binding declaration.", category=BugPattern.Category.GUICE, severity=BugPattern.SeverityLevel.ERROR)
public class ProvidesMethodOutsideOfModule
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final Matcher<AnnotationTree> PROVIDES_ANNOTATION_ON_METHOD_OUTSIDE_OF_MODULE = Matchers.allOf((Matcher[])new Matcher[]{Matchers.isType((String)"com.google.inject.Provides"), Matchers.not((Matcher)InjectMatchers.INSIDE_GUICE_MODULE)});

    public Description matchAnnotation(AnnotationTree annotation, VisitorState state) {
        if (PROVIDES_ANNOTATION_ON_METHOD_OUTSIDE_OF_MODULE.matches((Tree)annotation, state)) {
            return this.describeMatch(annotation, (Fix)SuggestedFix.delete((Tree)annotation));
        }
        return Description.NO_MATCH;
    }
}

