/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.overloading;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.bugpatterns.overloading.AutoValue_ParameterTrie_Parameter;
import com.google.errorprone.bugpatterns.overloading.ParameterOrderingViolation;
import com.google.errorprone.bugpatterns.overloading.ParameterTree;
import com.sun.source.tree.MethodTree;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.Name;

class ParameterTrie {
    private final Map<Name, ParameterTrie> children = new HashMap<Name, ParameterTrie>();

    public Optional<ParameterOrderingViolation> extendAndComputeViolation(MethodTree methodTree) {
        return new ParameterTrieExtender(methodTree).execute(this);
    }

    static int getMethodTreeArity(MethodTree methodTree) {
        return methodTree.getParameters().size();
    }

    static abstract class Parameter {
        Parameter() {
        }

        public abstract ParameterTree tree();

        public abstract int position();

        public Name name() {
            return this.tree().getName();
        }

        public static Parameter create(MethodTree methodTree, int position) {
            ParameterTree parameterTree = ParameterTree.create(methodTree.getParameters().get(position));
            return new AutoValue_ParameterTrie_Parameter(parameterTree, position);
        }
    }

    private static class ParameterTrieExtender {
        private final MethodTree methodTree;
        private final SortedSet<Parameter> inputParameters;
        private final List<Parameter> outputParameters;

        public ParameterTrieExtender(MethodTree methodTree) {
            this.methodTree = methodTree;
            this.inputParameters = new TreeSet<Parameter>(Comparator.comparingInt(Parameter::position));
            this.outputParameters = new ArrayList<Parameter>();
        }

        public Optional<ParameterOrderingViolation> execute(ParameterTrie trie) {
            Preconditions.checkArgument((trie != null ? 1 : 0) != 0);
            this.initialize();
            this.walk(trie);
            return this.validate();
        }

        private void initialize() {
            for (int i = 0; i < ParameterTrie.getMethodTreeArity(this.methodTree); ++i) {
                this.inputParameters.add(Parameter.create(this.methodTree, i));
            }
            this.outputParameters.clear();
        }

        private void walk(ParameterTrie trie) {
            Preconditions.checkArgument((trie != null ? 1 : 0) != 0);
            for (Parameter parameter : this.inputParameters) {
                if (parameter.tree().isVarArgs() || !trie.children.containsKey(parameter.name())) continue;
                this.inputParameters.remove(parameter);
                this.outputParameters.add(parameter);
                this.walk((ParameterTrie)trie.children.get(parameter.name()));
                return;
            }
            this.expand(trie);
        }

        private void expand(ParameterTrie trie) {
            Preconditions.checkArgument((trie != null ? 1 : 0) != 0);
            if (this.inputParameters.isEmpty()) {
                return;
            }
            Parameter parameter = this.inputParameters.first();
            this.inputParameters.remove(parameter);
            this.outputParameters.add(parameter);
            ParameterTrie allocatedTrie = new ParameterTrie();
            if (!parameter.tree().isVarArgs()) {
                trie.children.put(parameter.name(), allocatedTrie);
            }
            this.expand(allocatedTrie);
        }

        private Optional<ParameterOrderingViolation> validate() {
            ImmutableList.Builder actual = ImmutableList.builder();
            ImmutableList.Builder expected = ImmutableList.builder();
            boolean valid = true;
            for (int i = 0; i < this.outputParameters.size(); ++i) {
                Parameter parameter = this.outputParameters.get(i);
                if (parameter.position() != i) {
                    valid = false;
                }
                actual.add((Object)parameter.tree());
                expected.add((Object)this.getParameterTree(parameter.position()));
            }
            if (valid) {
                return Optional.empty();
            }
            ParameterOrderingViolation violation = ParameterOrderingViolation.builder().setMethodTree(this.methodTree).setActual((ImmutableList<ParameterTree>)actual.build()).setExpected((ImmutableList<ParameterTree>)expected.build()).build();
            return Optional.of(violation);
        }

        private ParameterTree getParameterTree(int position) {
            return ParameterTree.create(this.methodTree.getParameters().get(position));
        }
    }
}

