/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.FailureStrategy;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import javax.annotation.Nullable;

public final class ThrowableSubject
extends Subject<ThrowableSubject, Throwable> {
    static ThrowableSubject create(FailureStrategy failureStrategy, @Nullable Throwable throwable) {
        return new ThrowableSubject(ThrowableSubject.causeInsertingStrategy(failureStrategy, throwable), throwable);
    }

    private ThrowableSubject(FailureStrategy failureStrategy, @Nullable Throwable throwable) {
        super(failureStrategy, throwable);
    }

    @Deprecated
    public void hasMessage(@Nullable String expected) {
        this.hasMessageThat().isEqualTo(expected);
    }

    public StringSubject hasMessageThat() {
        return new StringSubject(this.badMessageStrategy(this.failureStrategy), ((Throwable)this.actual()).getMessage());
    }

    public ThrowableSubject hasCauseThat() {
        if (this.actual() == null) {
            this.failWithRawMessage("Causal chain is not deep enough - add a .isNotNull() check?", new Object[0]);
        }
        return new ThrowableSubject(this.badCauseStrategy(this.failureStrategy), ((Throwable)this.actual()).getCause());
    }

    private static FailureStrategy causeInsertingStrategy(final FailureStrategy delegate, final Throwable defaultCause) {
        return new FailureStrategy(){

            @Override
            public void fail(String message) {
                delegate.fail(message, defaultCause);
            }

            @Override
            public void fail(String message, Throwable cause) {
                delegate.fail(message, cause);
            }

            @Override
            public void failComparing(String message, CharSequence expected, CharSequence actual) {
                try {
                    delegate.failComparing(message, expected, actual);
                }
                catch (AssertionError e) {
                    ((Throwable)((Object)e)).initCause(defaultCause);
                    throw e;
                }
            }
        };
    }

    private FailureStrategy badMessageStrategy(final FailureStrategy delegate) {
        return new FailureStrategy(){

            private String prependMessage(String message) {
                String name = ((Throwable)ThrowableSubject.this.actual()).getClass().getName();
                if (ThrowableSubject.this.internalCustomName() != null) {
                    name = ThrowableSubject.this.internalCustomName() + "(" + name + ")";
                }
                return "Unexpected message for " + name + ":" + (message.isEmpty() ? "" : " " + message);
            }

            @Override
            public void fail(String message) {
                delegate.fail(this.prependMessage(message));
            }

            @Override
            public void fail(String message, Throwable cause) {
                delegate.fail(this.prependMessage(message), cause);
            }

            @Override
            public void failComparing(String message, CharSequence expected, CharSequence actual) {
                delegate.failComparing(this.prependMessage(message), expected, actual);
            }
        };
    }

    private FailureStrategy badCauseStrategy(final FailureStrategy delegate) {
        return new FailureStrategy(){

            private String prependMessage(String message) {
                String name = ((Throwable)ThrowableSubject.this.actual()).getClass().getName();
                if (ThrowableSubject.this.internalCustomName() != null) {
                    name = ThrowableSubject.this.internalCustomName() + "(" + name + ")";
                }
                return "Unexpected cause for " + name + ":" + (message.isEmpty() ? "" : " " + message);
            }

            @Override
            public void fail(String message) {
                delegate.fail(this.prependMessage(message));
            }

            @Override
            public void fail(String message, Throwable cause) {
                delegate.fail(this.prependMessage(message), cause);
            }

            @Override
            public void failComparing(String message, CharSequence expected, CharSequence actual) {
                delegate.failComparing(this.prependMessage(message), expected, actual);
            }
        };
    }
}

