/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Optional;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import com.google.common.truth.AbstractDelegatedVerb;
import com.google.common.truth.AbstractVerb;
import com.google.common.truth.AtomicLongMapSubject;
import com.google.common.truth.BigDecimalSubject;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.ClassSubject;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.DefaultSubject;
import com.google.common.truth.DelegatedVerbFactory;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.FloatSubject;
import com.google.common.truth.GuavaOptionalSubject;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.ListMultimapSubject;
import com.google.common.truth.LongSubject;
import com.google.common.truth.MapSubject;
import com.google.common.truth.MultimapSubject;
import com.google.common.truth.MultisetSubject;
import com.google.common.truth.ObjectArraySubject;
import com.google.common.truth.Platform;
import com.google.common.truth.PrimitiveBooleanArraySubject;
import com.google.common.truth.PrimitiveByteArraySubject;
import com.google.common.truth.PrimitiveCharArraySubject;
import com.google.common.truth.PrimitiveDoubleArraySubject;
import com.google.common.truth.PrimitiveFloatArraySubject;
import com.google.common.truth.PrimitiveIntArraySubject;
import com.google.common.truth.PrimitiveLongArraySubject;
import com.google.common.truth.PrimitiveShortArraySubject;
import com.google.common.truth.SetMultimapSubject;
import com.google.common.truth.SortedMapSubject;
import com.google.common.truth.SortedSetSubject;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.TableSubject;
import com.google.common.truth.TestVerb;
import com.google.common.truth.ThrowableSubject;
import com.google.common.util.concurrent.AtomicLongMap;
import java.math.BigDecimal;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.Nullable;

public final class Truth {
    public static final FailureStrategy THROW_ASSERTION_ERROR = new FailureStrategy(){

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual) {
            throw Platform.comparisonFailure(message, expected.toString(), actual.toString());
        }
    };
    private static final TestVerb ASSERT = new TestVerb(THROW_ASSERTION_ERROR);

    private Truth() {
    }

    public static TestVerb assert_() {
        return ASSERT;
    }

    public static TestVerb assertWithMessage(String messageToPrepend) {
        return Truth.assert_().withFailureMessage(messageToPrepend);
    }

    public static TestVerb assertWithMessage(String format, Object ... args) {
        return Truth.assert_().withFailureMessage(format, args);
    }

    public static <S extends Subject<S, T>, T> AbstractVerb.DelegatedVerb<S, T> assertAbout(SubjectFactory<S, T> factory) {
        return Truth.assert_().about(factory);
    }

    public static <V extends AbstractDelegatedVerb<V>> V assertAbout(DelegatedVerbFactory<V> factory) {
        return Truth.assert_().about(factory);
    }

    public static <T extends Comparable<?>> ComparableSubject<?, T> assertThat(@Nullable T target) {
        return Truth.assert_().that(target);
    }

    public static BigDecimalSubject assertThat(@Nullable BigDecimal target) {
        return Truth.assert_().that(target);
    }

    public static Subject<DefaultSubject, Object> assertThat(@Nullable Object target) {
        return Truth.assert_().that(target);
    }

    @GwtIncompatible(value="ClassSubject.java")
    public static ClassSubject assertThat(@Nullable Class<?> target) {
        return Truth.assert_().that(target);
    }

    public static ThrowableSubject assertThat(@Nullable Throwable target) {
        return Truth.assert_().that(target);
    }

    public static LongSubject assertThat(@Nullable Long target) {
        return Truth.assert_().that(target);
    }

    public static DoubleSubject assertThat(@Nullable Double target) {
        return Truth.assert_().that(target);
    }

    public static FloatSubject assertThat(@Nullable Float target) {
        return Truth.assert_().that(target);
    }

    public static IntegerSubject assertThat(@Nullable Integer target) {
        return Truth.assert_().that(target);
    }

    public static BooleanSubject assertThat(@Nullable Boolean target) {
        return Truth.assert_().that(target);
    }

    public static StringSubject assertThat(@Nullable String target) {
        return Truth.assert_().that(target);
    }

    public static IterableSubject assertThat(@Nullable Iterable<?> target) {
        return Truth.assert_().that(target);
    }

    public static SortedSetSubject assertThat(@Nullable SortedSet<?> target) {
        return Truth.assert_().that(target);
    }

    public static <T> ObjectArraySubject<T> assertThat(@Nullable T[] target) {
        return Truth.assert_().that(target);
    }

    public static PrimitiveBooleanArraySubject assertThat(@Nullable boolean[] target) {
        return Truth.assert_().that(target);
    }

    public static PrimitiveShortArraySubject assertThat(@Nullable short[] target) {
        return Truth.assert_().that(target);
    }

    public static PrimitiveIntArraySubject assertThat(@Nullable int[] target) {
        return Truth.assert_().that(target);
    }

    public static PrimitiveLongArraySubject assertThat(@Nullable long[] target) {
        return Truth.assert_().that(target);
    }

    public static PrimitiveByteArraySubject assertThat(@Nullable byte[] target) {
        return Truth.assert_().that(target);
    }

    public static PrimitiveCharArraySubject assertThat(@Nullable char[] target) {
        return Truth.assert_().that(target);
    }

    public static PrimitiveFloatArraySubject assertThat(@Nullable float[] target) {
        return Truth.assert_().that(target);
    }

    public static PrimitiveDoubleArraySubject assertThat(@Nullable double[] target) {
        return Truth.assert_().that(target);
    }

    public static GuavaOptionalSubject assertThat(@Nullable Optional<?> target) {
        return Truth.assert_().that(target);
    }

    public static MapSubject assertThat(@Nullable Map<?, ?> target) {
        return Truth.assert_().that(target);
    }

    public static SortedMapSubject assertThat(@Nullable SortedMap<?, ?> target) {
        return Truth.assert_().that(target);
    }

    public static MultimapSubject assertThat(@Nullable Multimap<?, ?> target) {
        return Truth.assert_().that(target);
    }

    public static ListMultimapSubject assertThat(@Nullable ListMultimap<?, ?> target) {
        return Truth.assert_().that(target);
    }

    public static SetMultimapSubject assertThat(@Nullable SetMultimap<?, ?> target) {
        return Truth.assert_().that(target);
    }

    public static MultisetSubject assertThat(@Nullable Multiset<?> target) {
        return Truth.assert_().that(target);
    }

    public static TableSubject assertThat(@Nullable Table<?, ?, ?> target) {
        return Truth.assert_().that(target);
    }

    public static AtomicLongMapSubject assertThat(@Nullable AtomicLongMap<?> target) {
        return Truth.assert_().that(target);
    }
}

