/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.zip.Zip;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClassPathBinder {
    public static final String TRANSITIVE_PREFIX = "META-INF/TRANSITIVE/";

    public static CompoundEnv<ClassSymbol, BytecodeBoundClass> bind(Collection<Path> classpath, Collection<Path> bootclasspath, TopLevelIndex.Builder tli) throws IOException {
        Env<ClassSymbol, BytecodeBoundClass> cp = ClassPathBinder.bindClasspath(tli, classpath);
        Env<ClassSymbol, BytecodeBoundClass> bcp = ClassPathBinder.bindClasspath(tli, bootclasspath);
        return CompoundEnv.of(cp).append(bcp);
    }

    private static Env<ClassSymbol, BytecodeBoundClass> bindClasspath(TopLevelIndex.Builder tli, Collection<Path> paths) throws IOException {
        LinkedHashMap<ClassSymbol, BytecodeBoundClass> transitive = new LinkedHashMap<ClassSymbol, BytecodeBoundClass>();
        final HashMap<ClassSymbol, BytecodeBoundClass> map = new HashMap<ClassSymbol, BytecodeBoundClass>();
        Env<ClassSymbol, BytecodeBoundClass> benv = new Env<ClassSymbol, BytecodeBoundClass>(){

            @Override
            public BytecodeBoundClass get(ClassSymbol sym) {
                return (BytecodeBoundClass)map.get(sym);
            }
        };
        for (Path path : paths) {
            try {
                ClassPathBinder.bindJar(tli, path, map, benv, transitive);
            }
            catch (IOException e) {
                throw new IOException("error reading " + path, e);
            }
        }
        for (Map.Entry entry : transitive.entrySet()) {
            ClassSymbol symbol = (ClassSymbol)entry.getKey();
            if (map.containsKey(symbol)) continue;
            map.put(symbol, (BytecodeBoundClass)entry.getValue());
            tli.insert(symbol);
        }
        return new SimpleEnv<ClassSymbol, BytecodeBoundClass>(ImmutableMap.copyOf(map));
    }

    private static void bindJar(TopLevelIndex.Builder tli, final Path path, Map<ClassSymbol, BytecodeBoundClass> env, final Env<ClassSymbol, BytecodeBoundClass> benv, Map<ClassSymbol, BytecodeBoundClass> transitive) throws IOException {
        for (final Zip.Entry ze : new Zip.ZipIterable(path)) {
            ClassSymbol sym;
            String name = ze.name();
            if (!name.endsWith(".class")) continue;
            if (name.startsWith(TRANSITIVE_PREFIX)) {
                sym = new ClassSymbol(name.substring(TRANSITIVE_PREFIX.length(), name.length() - ".class".length()));
                transitive.computeIfAbsent(sym, (java.util.function.Function<ClassSymbol, BytecodeBoundClass>)new Function<ClassSymbol, BytecodeBoundClass>(){

                    public BytecodeBoundClass apply(ClassSymbol sym) {
                        return new BytecodeBoundClass(sym, (Supplier<byte[]>)ClassPathBinder.toByteArrayOrDie(ze), benv, path.toString());
                    }
                });
                continue;
            }
            sym = new ClassSymbol(name.substring(0, name.length() - ".class".length()));
            if (env.containsKey(sym)) continue;
            env.put(sym, new BytecodeBoundClass(sym, ClassPathBinder.toByteArrayOrDie(ze), benv, path.toString()));
            tli.insert(sym);
        }
    }

    private static Supplier<byte[]> toByteArrayOrDie(final Zip.Entry ze) {
        return Suppliers.memoize((Supplier)new Supplier<byte[]>(){

            public byte[] get() {
                return ze.data();
            }
        });
    }
}

