/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.bytecode.sig.Sig;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.util.ArrayList;
import java.util.function.Function;

public class BytecodeBinder {
    static Type.ClassTy bindClassTy(Sig.ClassTySig sig, Function<String, TyVarSymbol> scope) {
        StringBuilder sb = new StringBuilder(sig.pkg());
        boolean first = true;
        ArrayList<Type.ClassTy.SimpleClassTy> classes = new ArrayList<Type.ClassTy.SimpleClassTy>();
        for (Sig.SimpleClassTySig s : sig.classes()) {
            sb.append(first ? (char)'/' : '$');
            sb.append(s.simpleName());
            ClassSymbol sym = new ClassSymbol(sb.toString());
            ImmutableList.Builder tyArgs = ImmutableList.builder();
            for (Sig.TySig arg : s.tyArgs()) {
                tyArgs.add((Object)BytecodeBinder.bindTy(arg, scope));
            }
            classes.add(new Type.ClassTy.SimpleClassTy(sym, (ImmutableList<Type>)tyArgs.build(), (ImmutableList<AnnoInfo>)ImmutableList.of()));
            first = false;
        }
        return new Type.ClassTy(classes);
    }

    private static Type wildTy(Sig.WildTySig sig, Function<String, TyVarSymbol> scope) {
        switch (sig.boundKind()) {
            case NONE: {
                return new Type.WildUnboundedTy((ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case LOWER: {
                return new Type.WildLowerBoundedTy(BytecodeBinder.bindTy(((Sig.LowerBoundTySig)sig).bound(), scope), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case UPPER: {
                return new Type.WildUpperBoundedTy(BytecodeBinder.bindTy(((Sig.UpperBoundTySig)sig).bound(), scope), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
        }
        throw new AssertionError((Object)sig.boundKind());
    }

    static Type bindTy(Sig.TySig sig, Function<String, TyVarSymbol> scope) {
        switch (sig.kind()) {
            case BASE_TY_SIG: {
                return new Type.PrimTy(((Sig.BaseTySig)sig).type(), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case CLASS_TY_SIG: {
                return BytecodeBinder.bindClassTy((Sig.ClassTySig)sig, scope);
            }
            case TY_VAR_SIG: {
                return new Type.TyVar(scope.apply(((Sig.TyVarSig)sig).name()), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case ARRAY_TY_SIG: {
                return BytecodeBinder.bindArrayTy((Sig.ArrayTySig)sig, scope);
            }
            case WILD_TY_SIG: {
                return BytecodeBinder.wildTy((Sig.WildTySig)sig, scope);
            }
        }
        throw new AssertionError((Object)sig.kind());
    }

    private static Type bindArrayTy(Sig.ArrayTySig arrayTySig, Function<String, TyVarSymbol> scope) {
        return new Type.ArrayTy(BytecodeBinder.bindTy(arrayTySig.elementType(), scope), (ImmutableList<AnnoInfo>)ImmutableList.of());
    }
}

