/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.model;

import com.google.common.collect.ImmutableList;
import com.google.turbine.model.TurbineConstantTypeKind;

public abstract class Const {
    public abstract Kind kind();

    public static class ArrayInitValue
    extends Const {
        private final ImmutableList<Const> elements;

        public ArrayInitValue(ImmutableList<Const> elements) {
            this.elements = elements;
        }

        @Override
        public Kind kind() {
            return Kind.ARRAY;
        }

        public ImmutableList<Const> elements() {
            return this.elements;
        }
    }

    public static class ByteValue
    extends Value {
        private final byte value;

        public ByteValue(byte value) {
            this.value = value;
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.BYTE;
        }

        public byte value() {
            return this.value;
        }

        @Override
        public IntValue asInteger() {
            return new IntValue(this.value);
        }

        @Override
        public ByteValue asByte() {
            return this;
        }

        @Override
        public LongValue asLong() {
            return new LongValue(this.value);
        }

        @Override
        public CharValue asChar() {
            return new CharValue((char)this.value);
        }

        @Override
        public ShortValue asShort() {
            return new ShortValue(this.value);
        }

        @Override
        public DoubleValue asDouble() {
            return new DoubleValue(this.value);
        }

        @Override
        public FloatValue asFloat() {
            return new FloatValue(this.value);
        }

        @Override
        public StringValue asString() {
            return new StringValue(String.valueOf(this.value));
        }
    }

    public static class ShortValue
    extends Value {
        private final short value;

        public ShortValue(short value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.SHORT;
        }

        public short value() {
            return this.value;
        }

        @Override
        public IntValue asInteger() {
            return new IntValue(this.value);
        }

        @Override
        public ByteValue asByte() {
            return new ByteValue((byte)this.value);
        }

        @Override
        public LongValue asLong() {
            return new LongValue(this.value);
        }

        @Override
        public CharValue asChar() {
            return new CharValue((char)this.value);
        }

        @Override
        public ShortValue asShort() {
            return this;
        }

        @Override
        public DoubleValue asDouble() {
            return new DoubleValue(this.value);
        }

        @Override
        public FloatValue asFloat() {
            return new FloatValue(this.value);
        }

        @Override
        public StringValue asString() {
            return new StringValue(String.valueOf(this.value));
        }
    }

    public static class StringValue
    extends Value {
        private final String value;

        public StringValue(String value) {
            this.value = value;
        }

        public String toString() {
            return String.format("\"%s\"", this.value);
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.STRING;
        }

        public String value() {
            return this.value;
        }

        @Override
        public StringValue asString() {
            return this;
        }
    }

    public static class DoubleValue
    extends Value {
        private final double value;

        public DoubleValue(double value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.DOUBLE;
        }

        public double value() {
            return this.value;
        }

        @Override
        public IntValue asInteger() {
            return new IntValue((int)this.value);
        }

        @Override
        public ByteValue asByte() {
            return new ByteValue((byte)this.value);
        }

        @Override
        public LongValue asLong() {
            return new LongValue((long)this.value);
        }

        @Override
        public CharValue asChar() {
            return new CharValue((char)this.value);
        }

        @Override
        public ShortValue asShort() {
            return new ShortValue((short)this.value);
        }

        @Override
        public DoubleValue asDouble() {
            return this;
        }

        @Override
        public FloatValue asFloat() {
            return new FloatValue((float)this.value);
        }

        @Override
        public StringValue asString() {
            return new StringValue(String.valueOf(this.value));
        }
    }

    public static class FloatValue
    extends Value {
        private final float value;

        public FloatValue(float value) {
            this.value = value;
        }

        public String toString() {
            return this.value + "f";
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.FLOAT;
        }

        public float value() {
            return this.value;
        }

        @Override
        public IntValue asInteger() {
            return new IntValue((int)this.value);
        }

        @Override
        public ByteValue asByte() {
            return new ByteValue((byte)this.value);
        }

        @Override
        public LongValue asLong() {
            return new LongValue((long)this.value);
        }

        @Override
        public CharValue asChar() {
            return new CharValue((char)this.value);
        }

        @Override
        public ShortValue asShort() {
            return new ShortValue((short)this.value);
        }

        @Override
        public DoubleValue asDouble() {
            return new DoubleValue(this.value);
        }

        @Override
        public FloatValue asFloat() {
            return this;
        }

        @Override
        public StringValue asString() {
            return new StringValue(String.valueOf(this.value));
        }
    }

    public static class CharValue
    extends Value {
        private final char value;

        public CharValue(char value) {
            this.value = value;
        }

        public String toString() {
            return "'" + this.value + "'";
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.CHAR;
        }

        public char value() {
            return this.value;
        }

        @Override
        public IntValue asInteger() {
            return new IntValue(this.value);
        }

        @Override
        public ByteValue asByte() {
            return new ByteValue((byte)this.value);
        }

        @Override
        public LongValue asLong() {
            return new LongValue(this.value);
        }

        @Override
        public CharValue asChar() {
            return this;
        }

        @Override
        public ShortValue asShort() {
            return new ShortValue((short)this.value);
        }

        @Override
        public DoubleValue asDouble() {
            return new DoubleValue(this.value);
        }

        @Override
        public FloatValue asFloat() {
            return new FloatValue(this.value);
        }

        @Override
        public StringValue asString() {
            return new StringValue(String.valueOf(this.value));
        }
    }

    public static class LongValue
    extends Value {
        private final long value;

        public LongValue(long value) {
            this.value = value;
        }

        public String toString() {
            return this.value + "L";
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.LONG;
        }

        public long value() {
            return this.value;
        }

        @Override
        public IntValue asInteger() {
            return new IntValue((int)this.value);
        }

        @Override
        public ByteValue asByte() {
            return new ByteValue((byte)this.value);
        }

        @Override
        public LongValue asLong() {
            return this;
        }

        @Override
        public CharValue asChar() {
            return new CharValue((char)this.value);
        }

        @Override
        public ShortValue asShort() {
            return new ShortValue((short)this.value);
        }

        @Override
        public DoubleValue asDouble() {
            return new DoubleValue(this.value);
        }

        @Override
        public FloatValue asFloat() {
            return new FloatValue(this.value);
        }

        @Override
        public StringValue asString() {
            return new StringValue(String.valueOf(this.value));
        }
    }

    public static class IntValue
    extends Value {
        private final int value;

        public IntValue(int value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.INT;
        }

        public int value() {
            return this.value;
        }

        @Override
        public IntValue asInteger() {
            return this;
        }

        @Override
        public ByteValue asByte() {
            return new ByteValue((byte)this.value);
        }

        @Override
        public LongValue asLong() {
            return new LongValue(this.value);
        }

        @Override
        public CharValue asChar() {
            return new CharValue((char)this.value);
        }

        @Override
        public ShortValue asShort() {
            return new ShortValue((short)this.value);
        }

        @Override
        public DoubleValue asDouble() {
            return new DoubleValue(this.value);
        }

        @Override
        public FloatValue asFloat() {
            return new FloatValue(this.value);
        }

        @Override
        public StringValue asString() {
            return new StringValue(String.valueOf(this.value));
        }
    }

    public static class BooleanValue
    extends Value {
        private final boolean value;

        public BooleanValue(boolean value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @Override
        public TurbineConstantTypeKind constantTypeKind() {
            return TurbineConstantTypeKind.BOOLEAN;
        }

        public boolean value() {
            return this.value;
        }

        @Override
        public BooleanValue asBoolean() {
            return this;
        }

        @Override
        public StringValue asString() {
            return new StringValue(String.valueOf(this.value));
        }
    }

    public static abstract class Value
    extends Const {
        public abstract TurbineConstantTypeKind constantTypeKind();

        @Override
        public Kind kind() {
            return Kind.PRIMITIVE;
        }

        public IntValue asInteger() {
            throw new AssertionError((Object)this.constantTypeKind());
        }

        public FloatValue asFloat() {
            throw new AssertionError((Object)this.constantTypeKind());
        }

        public DoubleValue asDouble() {
            throw new AssertionError((Object)this.constantTypeKind());
        }

        public LongValue asLong() {
            throw new AssertionError((Object)this.constantTypeKind());
        }

        public BooleanValue asBoolean() {
            throw new AssertionError((Object)this.constantTypeKind());
        }

        public StringValue asString() {
            throw new AssertionError((Object)this.constantTypeKind());
        }

        public CharValue asChar() {
            throw new AssertionError((Object)this.constantTypeKind());
        }

        public ShortValue asShort() {
            throw new AssertionError((Object)this.constantTypeKind());
        }

        public ByteValue asByte() {
            throw new AssertionError((Object)this.constantTypeKind());
        }
    }

    public static enum Kind {
        ARRAY,
        PRIMITIVE,
        CLASS_LITERAL,
        ENUM_CONSTANT,
        ANNOTATION;

    }
}

