/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import com.sun.tools.javah.Gen;
import com.sun.tools.javah.TypeSignature;
import com.sun.tools.javah.Util;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor9;

public class LLNI
extends Gen {
    protected final char innerDelim = (char)36;
    protected Set<String> doneHandleTypes;
    List<VariableElement> fields;
    List<ExecutableElement> methods;
    private boolean doubleAlign;
    private int padFieldNum = 0;
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    LLNI(boolean doubleAlign, Util util) {
        super(util);
        this.doubleAlign = doubleAlign;
    }

    @Override
    protected String getIncludes() {
        return "";
    }

    @Override
    protected void write(OutputStream o, TypeElement clazz) throws Util.Exit {
        try {
            String cname = this.mangleClassName(clazz.getQualifiedName().toString());
            PrintWriter pw = this.wrapWriter(o);
            this.fields = ElementFilter.fieldsIn(clazz.getEnclosedElements());
            this.methods = ElementFilter.methodsIn(clazz.getEnclosedElements());
            this.generateDeclsForClass(pw, clazz, cname);
        }
        catch (TypeSignature.SignatureException e) {
            this.util.error("llni.sigerror", e.getMessage());
        }
    }

    protected void generateDeclsForClass(PrintWriter pw, TypeElement clazz, String cname) throws TypeSignature.SignatureException, Util.Exit {
        this.doneHandleTypes = new HashSet<String>();
        this.genHandleType(null, "java.lang.Class");
        this.genHandleType(null, "java.lang.ClassLoader");
        this.genHandleType(null, "java.lang.Object");
        this.genHandleType(null, "java.lang.String");
        this.genHandleType(null, "java.lang.Thread");
        this.genHandleType(null, "java.lang.ThreadGroup");
        this.genHandleType(null, "java.lang.Throwable");
        pw.println("/* LLNI Header for class " + clazz.getQualifiedName() + " */" + this.lineSep);
        pw.println("#ifndef _Included_" + cname);
        pw.println("#define _Included_" + cname);
        pw.println("#include \"typedefs.h\"");
        pw.println("#include \"llni.h\"");
        pw.println("#include \"jni.h\"" + this.lineSep);
        this.forwardDecls(pw, clazz);
        this.structSectionForClass(pw, clazz, cname);
        this.methodSectionForClass(pw, clazz, cname);
        pw.println("#endif");
    }

    protected void genHandleType(PrintWriter pw, String clazzname) {
        String cname = this.mangleClassName(clazzname);
        if (!this.doneHandleTypes.contains(cname)) {
            this.doneHandleTypes.add(cname);
            if (pw != null) {
                pw.println("#ifndef DEFINED_" + cname);
                pw.println("    #define DEFINED_" + cname);
                pw.println("    GEN_HANDLE_TYPES(" + cname + ");");
                pw.println("#endif" + this.lineSep);
            }
        }
    }

    protected String mangleClassName(String s) {
        return s.replace('.', '_').replace('/', '_').replace('$', '_');
    }

    protected void forwardDecls(PrintWriter pw, TypeElement clazz) throws TypeSignature.SignatureException {
        String sig;
        TypeElement object = this.elems.getTypeElement("java.lang.Object");
        if (clazz.equals(object)) {
            return;
        }
        this.genHandleType(pw, clazz.getQualifiedName().toString());
        TypeElement superClass = (TypeElement)this.types.asElement(clazz.getSuperclass());
        if (superClass != null) {
            String superClassName = superClass.getQualifiedName().toString();
            this.forwardDecls(pw, superClass);
        }
        for (VariableElement field : this.fields) {
            TypeMirror t;
            String tname;
            TypeSignature newTypeSig;
            if (field.getModifiers().contains((Object)Modifier.STATIC) || (sig = (newTypeSig = new TypeSignature(this.elems)).getTypeSignature(tname = newTypeSig.qualifiedTypeName(t = this.types.erasure(field.asType())))).charAt(0) == '[') continue;
            this.forwardDeclsFromSig(pw, sig);
        }
        for (ExecutableElement method : this.methods) {
            if (!method.getModifiers().contains((Object)Modifier.NATIVE)) continue;
            TypeMirror retType = this.types.erasure(method.getReturnType());
            TypeSignature newTypeSig = new TypeSignature(this.elems);
            String typesig = this.signature(method);
            sig = newTypeSig.getTypeSignature(typesig, retType);
            if (sig.charAt(0) == '[') continue;
            this.forwardDeclsFromSig(pw, sig);
        }
    }

    protected void forwardDeclsFromSig(PrintWriter pw, String sig) {
        int i;
        int len = sig.length();
        int n = i = sig.charAt(0) == '(' ? 1 : 0;
        while (i < len) {
            if (sig.charAt(i) == 'L') {
                int j = i + 1;
                while (sig.charAt(j) != ';') {
                    ++j;
                }
                this.genHandleType(pw, sig.substring(i + 1, j));
                i = j + 1;
                continue;
            }
            ++i;
        }
    }

    protected void structSectionForClass(PrintWriter pw, TypeElement jclazz, String cname) {
        String jname = jclazz.getQualifiedName().toString();
        if (cname.equals("java_lang_Object")) {
            pw.println("/* struct java_lang_Object is defined in typedefs.h. */");
            pw.println();
            return;
        }
        pw.println("#if !defined(__i386)");
        pw.println("#pragma pack(4)");
        pw.println("#endif");
        pw.println();
        pw.println("struct " + cname + " {");
        pw.println("    ObjHeader h;");
        pw.print(this.fieldDefs(jclazz, cname));
        if (jname.equals("java.lang.Class")) {
            pw.println("    Class *LLNI_mask(cClass);  /* Fake field; don't access (see oobj.h) */");
        }
        pw.println("};" + this.lineSep + this.lineSep + "#pragma pack()");
        pw.println();
    }

    private boolean doField(FieldDefsRes res, VariableElement field, String cname, boolean padWord) {
        String fieldDef = this.addStructMember(field, cname, padWord);
        if (fieldDef != null) {
            if (!res.printedOne) {
                if (res.bottomMost) {
                    if (res.s.length() != 0) {
                        res.s = res.s + "    /* local members: */" + this.lineSep;
                    }
                } else {
                    res.s = res.s + "    /* inherited members from " + res.className + ": */" + this.lineSep;
                }
                res.printedOne = true;
            }
            res.s = res.s + fieldDef;
            return true;
        }
        return false;
    }

    private int doTwoWordFields(FieldDefsRes res, TypeElement clazz, int offset, String cname, boolean padWord) {
        boolean first = true;
        List<VariableElement> fields = ElementFilter.fieldsIn(clazz.getEnclosedElements());
        for (VariableElement field : fields) {
            TypeKind tk = field.asType().getKind();
            boolean twoWords = tk == TypeKind.LONG || tk == TypeKind.DOUBLE;
            if (!twoWords || !this.doField(res, field, cname, first && padWord)) continue;
            offset += 8;
            first = false;
        }
        return offset;
    }

    String fieldDefs(TypeElement clazz, String cname) {
        FieldDefsRes res = this.fieldDefs(clazz, cname, true);
        return res.s;
    }

    FieldDefsRes fieldDefs(TypeElement clazz, String cname, boolean bottomMost) {
        int offset;
        FieldDefsRes res;
        boolean didTwoWordFields = false;
        TypeElement superclazz = (TypeElement)this.types.asElement(clazz.getSuperclass());
        if (superclazz != null) {
            String supername = superclazz.getQualifiedName().toString();
            res = new FieldDefsRes(clazz, this.fieldDefs(superclazz, cname, false), bottomMost);
            offset = res.parent.byteSize;
        } else {
            res = new FieldDefsRes(clazz, null, bottomMost);
            offset = 0;
        }
        List<VariableElement> fields = ElementFilter.fieldsIn(clazz.getEnclosedElements());
        for (VariableElement field : fields) {
            TypeKind tk;
            boolean twoWords;
            if (this.doubleAlign && !didTwoWordFields && offset % 8 == 0) {
                offset = this.doTwoWordFields(res, clazz, offset, cname, false);
                didTwoWordFields = true;
            }
            boolean bl = twoWords = (tk = field.asType().getKind()) == TypeKind.LONG || tk == TypeKind.DOUBLE;
            if (this.doubleAlign && twoWords || !this.doField(res, field, cname, false)) continue;
            offset += 4;
        }
        if (this.doubleAlign && !didTwoWordFields) {
            if (offset % 8 != 0) {
                offset += 4;
            }
            offset = this.doTwoWordFields(res, clazz, offset, cname, true);
        }
        res.byteSize = offset;
        return res;
    }

    protected String addStructMember(VariableElement member, String cname, boolean padWord) {
        String res = null;
        if (member.getModifiers().contains((Object)Modifier.STATIC)) {
            res = this.addStaticStructMember(member, cname);
        } else {
            TypeMirror mt = this.types.erasure(member.asType());
            if (padWord) {
                res = "    java_int padWord" + this.padFieldNum++ + ";" + this.lineSep;
            }
            res = "    " + this.llniType(mt, false, false) + " " + this.llniFieldName(member);
            if (this.isLongOrDouble(mt)) {
                res = res + "[2]";
            }
            res = res + ";" + this.lineSep;
        }
        return res;
    }

    protected String addStaticStructMember(VariableElement field, String cname) {
        String res = null;
        Object exp = null;
        if (!field.getModifiers().contains((Object)Modifier.STATIC)) {
            return res;
        }
        if (!field.getModifiers().contains((Object)Modifier.FINAL)) {
            return res;
        }
        exp = field.getConstantValue();
        if (exp != null) {
            String cn = cname + "_" + field.getSimpleName();
            String suffix = null;
            long val = 0L;
            if (exp instanceof Byte || exp instanceof Short || exp instanceof Integer) {
                suffix = "L";
                val = ((Number)exp).intValue();
            } else if (exp instanceof Long) {
                suffix = isWindows ? "i64" : "LL";
                val = (Long)exp;
            } else if (exp instanceof Float) {
                suffix = "f";
            } else if (exp instanceof Double) {
                suffix = "";
            } else if (exp instanceof Character) {
                suffix = "L";
                Character ch = (Character)exp;
                val = ch.charValue() & 0xFFFF;
            }
            if (suffix != null) {
                res = suffix.equals("L") && val == Integer.MIN_VALUE || suffix.equals("LL") && val == Long.MIN_VALUE ? "    #undef  " + cn + this.lineSep + "    #define " + cn + " (" + (val + 1L) + suffix + "-1)" + this.lineSep : (suffix.equals("L") || suffix.endsWith("LL") ? "    #undef  " + cn + this.lineSep + "    #define " + cn + " " + val + suffix + this.lineSep : "    #undef  " + cn + this.lineSep + "    #define " + cn + " " + exp + suffix + this.lineSep);
            }
        }
        return res;
    }

    protected void methodSectionForClass(PrintWriter pw, TypeElement clazz, String cname) throws TypeSignature.SignatureException, Util.Exit {
        String methods = this.methodDecls(clazz, cname);
        if (methods.length() != 0) {
            pw.println("/* Native method declarations: */" + this.lineSep);
            pw.println("#ifdef __cplusplus");
            pw.println("extern \"C\" {");
            pw.println("#endif" + this.lineSep);
            pw.println(methods);
            pw.println("#ifdef __cplusplus");
            pw.println("}");
            pw.println("#endif");
        }
    }

    protected String methodDecls(TypeElement clazz, String cname) throws TypeSignature.SignatureException, Util.Exit {
        String res = "";
        for (ExecutableElement method : this.methods) {
            if (!method.getModifiers().contains((Object)Modifier.NATIVE)) continue;
            res = res + this.methodDecl(method, clazz, cname);
        }
        return res;
    }

    protected String methodDecl(ExecutableElement method, TypeElement clazz, String cname) throws TypeSignature.SignatureException, Util.Exit {
        String res = null;
        TypeMirror retType = this.types.erasure(method.getReturnType());
        String typesig = this.signature(method);
        TypeSignature newTypeSig = new TypeSignature(this.elems);
        String sig = newTypeSig.getTypeSignature(typesig, retType);
        boolean longName = this.needLongName(method, clazz);
        if (sig.charAt(0) != '(') {
            this.util.error("invalid.method.signature", sig);
        }
        res = "JNIEXPORT " + this.jniType(retType) + " JNICALL" + this.lineSep + this.jniMethodName(method, cname, longName) + "(JNIEnv *, " + this.cRcvrDecl(method, cname);
        List<? extends VariableElement> params = method.getParameters();
        ArrayList<TypeMirror> argTypes = new ArrayList<TypeMirror>();
        for (VariableElement variableElement : params) {
            argTypes.add(this.types.erasure(variableElement.asType()));
        }
        for (TypeMirror typeMirror : argTypes) {
            res = res + ", " + this.jniType(typeMirror);
        }
        res = res + ");" + this.lineSep;
        return res;
    }

    protected final boolean needLongName(ExecutableElement method, TypeElement clazz) {
        Name methodName = method.getSimpleName();
        for (ExecutableElement memberMethod : this.methods) {
            if (memberMethod == method || !memberMethod.getModifiers().contains((Object)Modifier.NATIVE) || !methodName.equals(memberMethod.getSimpleName())) continue;
            return true;
        }
        return false;
    }

    protected final String jniMethodName(ExecutableElement method, String cname, boolean longName) throws TypeSignature.SignatureException {
        String res = "Java_" + cname + "_" + method.getSimpleName();
        if (longName) {
            TypeMirror mType = this.types.erasure(method.getReturnType());
            List<? extends VariableElement> params = method.getParameters();
            ArrayList<TypeMirror> argTypes = new ArrayList<TypeMirror>();
            for (VariableElement variableElement : params) {
                argTypes.add(this.types.erasure(variableElement.asType()));
            }
            res = res + "__";
            for (TypeMirror typeMirror : argTypes) {
                String tname = typeMirror.toString();
                TypeSignature newTypeSig = new TypeSignature(this.elems);
                String sig = newTypeSig.getTypeSignature(tname);
                res = res + this.nameToIdentifier(sig);
            }
        }
        return res;
    }

    protected final String jniType(TypeMirror t) throws Util.Exit {
        TypeElement throwable = this.elems.getTypeElement("java.lang.Throwable");
        TypeElement jClass = this.elems.getTypeElement("java.lang.Class");
        TypeElement jString = this.elems.getTypeElement("java.lang.String");
        Element tclassDoc = this.types.asElement(t);
        switch (t.getKind()) {
            case ARRAY: {
                TypeMirror ct2 = ((ArrayType)t).getComponentType();
                switch (ct2.getKind()) {
                    case BOOLEAN: {
                        return "jbooleanArray";
                    }
                    case BYTE: {
                        return "jbyteArray";
                    }
                    case CHAR: {
                        return "jcharArray";
                    }
                    case SHORT: {
                        return "jshortArray";
                    }
                    case INT: {
                        return "jintArray";
                    }
                    case LONG: {
                        return "jlongArray";
                    }
                    case FLOAT: {
                        return "jfloatArray";
                    }
                    case DOUBLE: {
                        return "jdoubleArray";
                    }
                    case ARRAY: 
                    case DECLARED: {
                        return "jobjectArray";
                    }
                }
                throw new Error(ct2.toString());
            }
            case VOID: {
                return "void";
            }
            case BOOLEAN: {
                return "jboolean";
            }
            case BYTE: {
                return "jbyte";
            }
            case CHAR: {
                return "jchar";
            }
            case SHORT: {
                return "jshort";
            }
            case INT: {
                return "jint";
            }
            case LONG: {
                return "jlong";
            }
            case FLOAT: {
                return "jfloat";
            }
            case DOUBLE: {
                return "jdouble";
            }
            case DECLARED: {
                if (tclassDoc.equals(jString)) {
                    return "jstring";
                }
                if (this.types.isAssignable(t, throwable.asType())) {
                    return "jthrowable";
                }
                if (this.types.isAssignable(t, jClass.asType())) {
                    return "jclass";
                }
                return "jobject";
            }
        }
        this.util.bug("jni.unknown.type");
        return null;
    }

    protected String llniType(TypeMirror t, boolean handleize, boolean longDoubleOK) {
        String res = null;
        switch (t.getKind()) {
            case ARRAY: {
                TypeMirror ct2 = ((ArrayType)t).getComponentType();
                switch (ct2.getKind()) {
                    case BOOLEAN: {
                        res = "IArrayOfBoolean";
                        break;
                    }
                    case BYTE: {
                        res = "IArrayOfByte";
                        break;
                    }
                    case CHAR: {
                        res = "IArrayOfChar";
                        break;
                    }
                    case SHORT: {
                        res = "IArrayOfShort";
                        break;
                    }
                    case INT: {
                        res = "IArrayOfInt";
                        break;
                    }
                    case LONG: {
                        res = "IArrayOfLong";
                        break;
                    }
                    case FLOAT: {
                        res = "IArrayOfFloat";
                        break;
                    }
                    case DOUBLE: {
                        res = "IArrayOfDouble";
                        break;
                    }
                    case ARRAY: 
                    case DECLARED: {
                        res = "IArrayOfRef";
                        break;
                    }
                    default: {
                        throw new Error((Object)((Object)ct2.getKind()) + " " + ct2);
                    }
                }
                if (handleize) break;
                res = "DEREFERENCED_" + res;
                break;
            }
            case VOID: {
                res = "void";
                break;
            }
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                res = "java_int";
                break;
            }
            case LONG: {
                res = longDoubleOK ? "java_long" : "val32 /* java_long */";
                break;
            }
            case FLOAT: {
                res = "java_float";
                break;
            }
            case DOUBLE: {
                res = longDoubleOK ? "java_double" : "val32 /* java_double */";
                break;
            }
            case DECLARED: {
                TypeElement e = (TypeElement)this.types.asElement(t);
                res = "I" + this.mangleClassName(e.getQualifiedName().toString());
                if (handleize) break;
                res = "DEREFERENCED_" + res;
                break;
            }
            default: {
                throw new Error((Object)((Object)t.getKind()) + " " + t);
            }
        }
        return res;
    }

    protected final String cRcvrDecl(Element field, String cname) {
        return field.getModifiers().contains((Object)Modifier.STATIC) ? "jclass" : "jobject";
    }

    protected String maskName(String s) {
        return "LLNI_mask(" + s + ")";
    }

    protected String llniFieldName(VariableElement field) {
        return this.maskName(field.getSimpleName().toString());
    }

    protected final boolean isLongOrDouble(TypeMirror t) {
        SimpleTypeVisitor9<Boolean, Void> v = new SimpleTypeVisitor9<Boolean, Void>(){

            @Override
            public Boolean defaultAction(TypeMirror t, Void p) {
                return false;
            }

            @Override
            public Boolean visitArray(ArrayType t, Void p) {
                return (Boolean)this.visit(t.getComponentType(), p);
            }

            @Override
            public Boolean visitPrimitive(PrimitiveType t, Void p) {
                TypeKind tk = t.getKind();
                return tk == TypeKind.LONG || tk == TypeKind.DOUBLE;
            }
        };
        return (Boolean)v.visit(t, null);
    }

    protected final String nameToIdentifier(String name) {
        int len = name.length();
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (this.isASCIILetterOrDigit(c)) {
                buf.append(c);
                continue;
            }
            if (c == '/') {
                buf.append('_');
                continue;
            }
            if (c == '.') {
                buf.append('_');
                continue;
            }
            if (c == '_') {
                buf.append("_1");
                continue;
            }
            if (c == ';') {
                buf.append("_2");
                continue;
            }
            if (c == '[') {
                buf.append("_3");
                continue;
            }
            buf.append("_0" + c);
        }
        return new String(buf);
    }

    protected final boolean isASCIILetterOrDigit(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    private static class FieldDefsRes {
        public String className;
        public FieldDefsRes parent;
        public String s;
        public int byteSize;
        public boolean bottomMost;
        public boolean printedOne = false;

        FieldDefsRes(TypeElement clazz, FieldDefsRes parent, boolean bottomMost) {
            this.className = clazz.getQualifiedName().toString();
            this.parent = parent;
            this.bottomMost = bottomMost;
            boolean byteSize = false;
            this.s = parent == null ? "" : parent.s;
        }
    }
}

