/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server;

import com.sun.tools.javac.util.Assert;
import com.sun.tools.sjavac.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.util.concurrent.Semaphore;

public class PortFile {
    private static final int magicNr = 4468;
    private String filename;
    private File file;
    private File stopFile;
    private RandomAccessFile rwfile;
    private FileChannel channel;
    private FileLock lock;
    private Semaphore lockSem = new Semaphore(1);
    private boolean containsPortInfo;
    private int serverPort;
    private long serverCookie;
    private int myServerPort;
    private long myServerCookie;

    public PortFile(String fn) throws FileNotFoundException {
        this.filename = fn;
        this.file = new File(this.filename);
        this.stopFile = new File(this.filename + ".stop");
        this.rwfile = new RandomAccessFile(this.file, "rw");
        this.channel = this.rwfile.getChannel();
        this.containsPortInfo = false;
        this.lock = null;
    }

    public void lock() throws IOException, InterruptedException {
        this.lockSem.acquire();
        this.lock = this.channel.lock();
    }

    public void getValues() {
        this.containsPortInfo = false;
        if (this.lock == null) {
            return;
        }
        try {
            if (this.rwfile.length() > 0L) {
                this.rwfile.seek(0L);
                int nr = this.rwfile.readInt();
                this.serverPort = this.rwfile.readInt();
                this.serverCookie = this.rwfile.readLong();
                this.containsPortInfo = nr == 4468;
            }
        }
        catch (IOException e) {
            this.containsPortInfo = false;
        }
    }

    public boolean containsPortInfo() {
        return this.containsPortInfo;
    }

    public int getPort() {
        Assert.check(this.containsPortInfo);
        return this.serverPort;
    }

    public long getCookie() {
        Assert.check(this.containsPortInfo);
        return this.serverCookie;
    }

    public void setValues(int port, long cookie) throws IOException {
        Assert.check(this.lock != null);
        this.rwfile.seek(0L);
        this.rwfile.writeInt(4468);
        this.rwfile.writeInt(port);
        this.rwfile.writeLong(cookie);
        this.myServerPort = port;
        this.myServerCookie = cookie;
    }

    public void delete() throws IOException {
        this.rwfile.close();
        this.file.delete();
    }

    public boolean exists() throws IOException {
        return this.file.exists();
    }

    public boolean markedForStop() throws IOException {
        if (this.stopFile.exists()) {
            try {
                this.stopFile.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public void unlock() throws IOException {
        Assert.check(this.lock != null);
        this.lock.release();
        this.lock = null;
        this.lockSem.release();
    }

    public void waitForValidValues() throws IOException, InterruptedException {
        int MAX_ATTEMPTS = 10;
        int MS_BETWEEN_ATTEMPTS = 500;
        long startTime = System.currentTimeMillis();
        int attempt = 0;
        while (true) {
            Log.debug("Looking for valid port file values...");
            this.lock();
            this.getValues();
            this.unlock();
            if (this.containsPortInfo) {
                Log.debug("Valid port file values found after " + (System.currentTimeMillis() - startTime) + " ms");
                return;
            }
            if (attempt >= 10) {
                throw new IOException("No port file values materialized. Giving up after " + (System.currentTimeMillis() - startTime) + " ms");
            }
            Thread.sleep(500L);
            ++attempt;
        }
    }

    /*
     * Loose catch block
     */
    public boolean stillMyValues() throws IOException, FileNotFoundException, InterruptedException {
        while (true) {
            try {
                this.lock();
                this.getValues();
                this.unlock();
                if (this.containsPortInfo) {
                    return this.serverPort == this.myServerPort && this.serverCookie == this.myServerCookie;
                }
                return false;
            }
            catch (FileLockInterruptionException e) {
                continue;
            }
            break;
        }
        catch (ClosedChannelException e) {
            return false;
        }
    }

    public String getFilename() {
        return this.filename;
    }
}

