/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.client.MapKeyBasedClientRequest;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.TimeUnit;

public class MapPutRequest
extends MapKeyBasedClientRequest
implements Portable,
SecureRequest {
    protected Data key;
    protected Data value;
    protected long threadId;
    protected long ttl;
    protected transient long startTime;
    protected boolean async;

    public MapPutRequest() {
    }

    public MapPutRequest(String name, Data key, Data value, long threadId) {
        this(name, key, value, threadId, -1L);
    }

    public MapPutRequest(String name, Data key, Data value, long threadId, long ttl) {
        super(name);
        this.key = key;
        this.value = value;
        this.threadId = threadId;
        this.ttl = ttl;
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected void beforeProcess() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void beforeResponse() {
        long latency = System.currentTimeMillis() - this.startTime;
        MapService mapService = (MapService)this.getService();
        MapContainer mapContainer = mapService.getMapServiceContext().getMapContainer(this.name);
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            mapService.getMapServiceContext().getLocalMapStatsProvider().getLocalMapStatsImpl(this.name).incrementPuts(latency);
        }
    }

    @Override
    protected Operation prepareOperation() {
        MapOperation operation = this.getOperationProvider().createPutOperation(this.name, this.key, this.value, this.ttl);
        operation.setThreadId(this.threadId);
        return operation;
    }

    public void setAsAsync() {
        this.async = true;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeLong("t", this.threadId);
        writer.writeLong("ttl", this.ttl);
        writer.writeBoolean("a", this.async);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
        out.writeData(this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.threadId = reader.readLong("t");
        this.ttl = reader.readLong("ttl");
        this.async = reader.readBoolean("a");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
        this.value = in.readData();
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "put");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "put";
    }

    @Override
    public Object[] getParameters() {
        if (this.ttl == -1L) {
            return new Object[]{this.key, this.value};
        }
        return new Object[]{this.key, this.value, this.ttl, TimeUnit.MILLISECONDS};
    }
}

