/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MethodVisibility;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;

@BugPattern(name="FuzzyEqualsShouldNotBeUsedInEqualsMethod", summary="DoubleMath.fuzzyEquals should never be used in an Object.equals() method", explanation="From documentation: DoubleMath.fuzzyEquals is not transitive, so it is not suitable for use in Object#equals implementations.", category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.ERROR)
public class FuzzyEqualsShouldNotBeUsedInEqualsMethod
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodTree> EQUALS_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"equals"), Matchers.methodHasVisibility((MethodVisibility.Visibility)MethodVisibility.Visibility.PUBLIC), Matchers.methodReturns((Supplier)Suppliers.BOOLEAN_TYPE), Matchers.methodHasParameters((Matcher[])new Matcher[]{Matchers.variableType((Matcher)Matchers.isSameType((Supplier)Suppliers.OBJECT_TYPE))})});
    private static final Matcher<MethodInvocationTree> CALL_TO_FUZZY_IN_EQUALS = Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.math.DoubleMath").named("fuzzyEquals"), Matchers.enclosingMethod(EQUALS_MATCHER)});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (CALL_TO_FUZZY_IN_EQUALS.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

