/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Modifier;

@BugPattern(name="JUnit3TestNotRun", summary="Test method will not be run; please correct method signature (Should be public, non-static, and method name should begin with \"test\").", category=BugPattern.Category.JUNIT, severity=BugPattern.SeverityLevel.ERROR)
public class JUnit3TestNotRun
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Pattern MISSPELLED_NAME = Pattern.compile("t.est|te.st|tst|tet|tes|etst|tset|tets|t.st|te.t|[tT][eE][sS][tT]");
    private static final com.google.errorprone.matchers.Matcher<MethodTree> LOOKS_LIKE_TEST_CASE = Matchers.allOf((com.google.errorprone.matchers.Matcher[])new com.google.errorprone.matchers.Matcher[]{Matchers.enclosingClass((com.google.errorprone.matchers.Matcher)JUnitMatchers.isJUnit3TestClass), Matchers.not((com.google.errorprone.matchers.Matcher)JUnitMatchers.isJunit3TestCase), Matchers.methodReturns((Supplier)Suppliers.VOID_TYPE), Matchers.methodHasParameters((com.google.errorprone.matchers.Matcher[])new com.google.errorprone.matchers.Matcher[0])});

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        if (!LOOKS_LIKE_TEST_CASE.matches((Tree)methodTree, state)) {
            return Description.NO_MATCH;
        }
        ArrayList<SuggestedFix> fixes = new ArrayList<SuggestedFix>(0);
        if (Matchers.not((com.google.errorprone.matchers.Matcher)Matchers.methodNameStartsWith((String)"test")).matches((Tree)methodTree, state)) {
            String fixedName = methodTree.getName().toString();
            Matcher matcher = MISSPELLED_NAME.matcher(fixedName);
            if (matcher.lookingAt()) {
                fixedName = matcher.replaceFirst("test");
            } else if (JUnitMatchers.wouldRunInJUnit4.matches((Tree)methodTree, state)) {
                fixedName = "test" + fixedName.substring(0, 1).toUpperCase() + fixedName.substring(1);
            } else {
                return Description.NO_MATCH;
            }
            fixes.add(SuggestedFixes.renameMethod((MethodTree)methodTree, (String)fixedName, (VisitorState)state));
        }
        fixes.add(SuggestedFixes.addModifiers((Tree)methodTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PUBLIC}));
        fixes.add(SuggestedFixes.removeModifiers((Tree)methodTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.PROTECTED}));
        fixes.add(SuggestedFixes.removeModifiers((Tree)methodTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC}));
        return this.describeMatch(methodTree, JUnit3TestNotRun.mergeFixes(fixes));
    }

    private static Fix mergeFixes(List<SuggestedFix> fixesToMerge) {
        SuggestedFix.Builder builderForResult = SuggestedFix.builder();
        for (SuggestedFix fix : fixesToMerge) {
            if (fix == null) continue;
            builderForResult.merge(fix);
        }
        return builderForResult.build();
    }
}

