/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

@BugPattern(name="MultipleParallelOrSequentialCalls", summary="Multiple calls to either parallel or sequential are unnecessary and cause confusion.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class MultipleParallelOrSequentialCalls
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final MethodMatchers.MethodNameMatcher STREAM = Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("stream");
    private static final MethodMatchers.MethodNameMatcher PARALLELSTREAM = Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("parallelStream");

    public Description matchMethodInvocation(MethodInvocationTree t, VisitorState state) {
        if (STREAM.matches((Tree)t, state) || PARALLELSTREAM.matches((Tree)t, state)) {
            MethodInvocationTree methodInvocationTree;
            int n = STREAM.matches((Tree)t, state);
            SuggestedFix.Builder builder = SuggestedFix.builder();
            TreePath pathToMet = ASTHelpers.findPathFromEnclosingNodeToTopLevel((TreePath)state.getPath(), MethodInvocationTree.class);
            int count = 0;
            String toReplace = "empty";
            while (pathToMet != null && !(methodInvocationTree = (MethodInvocationTree)pathToMet.getLeaf()).getArguments().stream().map(m -> m.toString()).anyMatch(m -> m.contains(t.toString()))) {
                if (methodInvocationTree.getMethodSelect() instanceof MemberSelectTree) {
                    MemberSelectTree memberSelectTree = (MemberSelectTree)methodInvocationTree.getMethodSelect();
                    String memberSelectIdentifier = memberSelectTree.getIdentifier().toString();
                    if (toReplace.equals("empty") && (memberSelectIdentifier.equals("parallel") || memberSelectIdentifier.equals("sequential"))) {
                        String string = toReplace = memberSelectIdentifier.equals("parallel") ? "parallel" : "sequential";
                    }
                    if (memberSelectIdentifier.equals(toReplace)) {
                        int endOfExpression = state.getEndPosition((Tree)memberSelectTree.getExpression());
                        builder.replace(endOfExpression, state.getEndPosition((Tree)methodInvocationTree), "");
                        ++count;
                    }
                }
                pathToMet = ASTHelpers.findPathFromEnclosingNodeToTopLevel((TreePath)pathToMet, MethodInvocationTree.class);
            }
            if (count > n) {
                if (n) {
                    builder.postfixWith((Tree)t, "." + toReplace + "()");
                }
                return this.describeMatch(t, (Fix)builder.build());
            }
        }
        return Description.NO_MATCH;
    }
}

