/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency;

import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.LibraryDependency;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class LibraryBundle
implements LibraryDependency {
    public static final String FN_PROGUARD_TXT = "proguard.txt";
    private final File mBundle;
    private final File mBundleFolder;
    private final String mName;
    private final String mProjectPath;

    protected LibraryBundle(File bundle, File bundleFolder, String name, String projectPath) {
        this.mBundle = bundle;
        this.mBundleFolder = bundleFolder;
        this.mName = name;
        this.mProjectPath = projectPath;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public String getProject() {
        return this.mProjectPath;
    }

    public String getProjectVariant() {
        return null;
    }

    @Override
    public File getManifest() {
        return new File(this.mBundleFolder, "AndroidManifest.xml");
    }

    @Override
    public File getSymbolFile() {
        return new File(this.mBundleFolder, "R.txt");
    }

    public File getBundle() {
        return this.mBundle;
    }

    public File getFolder() {
        return this.mBundleFolder;
    }

    public File getJarFile() {
        return new File(this.getJarsRootFolder(), "classes.jar");
    }

    public List<JarDependency> getLocalDependencies() {
        Collection jars = this.getLocalJars();
        ArrayList localDependencies = Lists.newArrayListWithCapacity((int)jars.size());
        for (File jar : jars) {
            localDependencies.add(new JarDependency(jar, true, true, null, null));
        }
        return localDependencies;
    }

    public List<File> getLocalJars() {
        ArrayList localJars = Lists.newArrayList();
        File[] jarList = new File(this.getJarsRootFolder(), "libs").listFiles();
        if (jarList != null) {
            for (File jars : jarList) {
                if (!jars.isFile() || !jars.getName().endsWith(".jar")) continue;
                localJars.add(jars);
            }
        }
        return localJars;
    }

    public File getResFolder() {
        return new File(this.mBundleFolder, "res");
    }

    public File getAssetsFolder() {
        return new File(this.mBundleFolder, "assets");
    }

    public File getJniFolder() {
        return new File(this.mBundleFolder, "jni");
    }

    public File getAidlFolder() {
        return new File(this.mBundleFolder, "aidl");
    }

    public File getRenderscriptFolder() {
        return new File(this.mBundleFolder, "rs");
    }

    public File getProguardRules() {
        return new File(this.mBundleFolder, FN_PROGUARD_TXT);
    }

    public File getLintJar() {
        return new File(this.getJarsRootFolder(), "lint.jar");
    }

    public File getExternalAnnotations() {
        return new File(this.mBundleFolder, "annotations.zip");
    }

    public File getPublicResources() {
        return new File(this.mBundleFolder, "public.txt");
    }

    public File getBundleFolder() {
        return this.mBundleFolder;
    }

    protected File getJarsRootFolder() {
        return new File(this.mBundleFolder, "jars");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryBundle that = (LibraryBundle)o;
        return Objects.equal((Object)this.mName, (Object)that.mName) && Objects.equal((Object)this.mProjectPath, (Object)that.mProjectPath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mName, this.mProjectPath});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("mBundle", (Object)this.mBundle).add("mBundleFolder", (Object)this.mBundleFolder).add("mName", (Object)this.mName).add("mProjectPath", (Object)this.mProjectPath).toString();
    }
}

