/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.DerivedCollectionGenerators;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.SortedSetTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestSortedMapGenerator;
import com.google.common.collect.testing.TestSortedSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.testers.SortedMapNavigationTester;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestSuite;

@GwtIncompatible
public class SortedMapTestSuiteBuilder<K, V>
extends MapTestSuiteBuilder<K, V> {
    public static <K, V> SortedMapTestSuiteBuilder<K, V> using(TestSortedMapGenerator<K, V> generator) {
        SortedMapTestSuiteBuilder<K, V> result = new SortedMapTestSuiteBuilder<K, V>();
        result.usingGenerator(generator);
        return result;
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        List<Class<? extends AbstractTester>> testers = Helpers.copyToList(super.getTesters());
        testers.add(SortedMapNavigationTester.class);
        return testers;
    }

    @Override
    public TestSuite createTestSuite() {
        if (!this.getFeatures().contains(CollectionFeature.KNOWN_ORDER)) {
            List<Feature<?>> features = Helpers.copyToList(this.getFeatures());
            features.add(CollectionFeature.KNOWN_ORDER);
            this.withFeatures(features);
        }
        return super.createTestSuite();
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>>> parentBuilder) {
        List<TestSuite> derivedSuites = super.createDerivedSuites(parentBuilder);
        if (!parentBuilder.getFeatures().contains(NoRecurse.SUBMAP)) {
            derivedSuites.add(this.createSubmapSuite(parentBuilder, DerivedCollectionGenerators.Bound.NO_BOUND, DerivedCollectionGenerators.Bound.EXCLUSIVE));
            derivedSuites.add(this.createSubmapSuite(parentBuilder, DerivedCollectionGenerators.Bound.INCLUSIVE, DerivedCollectionGenerators.Bound.NO_BOUND));
            derivedSuites.add(this.createSubmapSuite(parentBuilder, DerivedCollectionGenerators.Bound.INCLUSIVE, DerivedCollectionGenerators.Bound.EXCLUSIVE));
        }
        return derivedSuites;
    }

    @Override
    protected SetTestSuiteBuilder<K> createDerivedKeySetSuite(TestSetGenerator<K> keySetGenerator) {
        return keySetGenerator instanceof TestSortedSetGenerator ? SortedSetTestSuiteBuilder.using((TestSortedSetGenerator)keySetGenerator) : SetTestSuiteBuilder.using(keySetGenerator);
    }

    final TestSuite createSubmapSuite(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Map<K, V>, Map.Entry<K, V>>> parentBuilder, DerivedCollectionGenerators.Bound from, DerivedCollectionGenerators.Bound to) {
        TestSortedMapGenerator delegate = (TestSortedMapGenerator)parentBuilder.getSubjectGenerator().getInnerGenerator();
        ArrayList features = new ArrayList();
        features.add(NoRecurse.SUBMAP);
        features.addAll(parentBuilder.getFeatures());
        String string = parentBuilder.getName();
        String string2 = String.valueOf((Object)from);
        String string3 = String.valueOf((Object)to);
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)this.newBuilderUsing(delegate, to, from).named(new StringBuilder(9 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(" subMap ").append(string2).append("-").append(string3).toString())).withFeatures(features)).suppressing(parentBuilder.getSuppressedTests())).createTestSuite();
    }

    SortedMapTestSuiteBuilder<K, V> newBuilderUsing(TestSortedMapGenerator<K, V> delegate, DerivedCollectionGenerators.Bound to, DerivedCollectionGenerators.Bound from) {
        return SortedMapTestSuiteBuilder.using(new DerivedCollectionGenerators.SortedMapSubmapTestMapGenerator<K, V>(delegate, to, from));
    }

    static enum NoRecurse implements Feature<Void>
    {
        SUBMAP,
        DESCENDING;


        @Override
        public Set<Feature<? super Void>> getImpliedFeatures() {
            return Collections.emptySet();
        }
    }
}

