/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;

@GwtCompatible
public class UnhashableObject
implements Comparable<UnhashableObject> {
    private final int value;

    public UnhashableObject(int value) {
        this.value = value;
    }

    public boolean equals(Object object) {
        if (object instanceof UnhashableObject) {
            UnhashableObject that = (UnhashableObject)object;
            return this.value == that.value;
        }
        return false;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        int n = this.value;
        return new StringBuilder(21).append("DontHashMe").append(n).toString();
    }

    @Override
    public int compareTo(UnhashableObject o) {
        return this.value < o.value ? -1 : (this.value > o.value ? 1 : 0);
    }
}

