/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import com.github.luben.zstd.ZstdOutputStreamNoFinalizer;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;

public class RecyclingBufferPool
implements BufferPool {
    public static final BufferPool INSTANCE = new RecyclingBufferPool();
    private static final int buffSize = Math.max(Math.max((int)ZstdOutputStreamNoFinalizer.recommendedCOutSize(), (int)ZstdInputStreamNoFinalizer.recommendedDInSize()), (int)ZstdInputStreamNoFinalizer.recommendedDOutSize());
    private final ArrayDeque<SoftReference<ByteBuffer>> pool = new ArrayDeque();

    private RecyclingBufferPool() {
    }

    @Override
    public synchronized ByteBuffer get(int capacity) {
        SoftReference<ByteBuffer> sbuf;
        ByteBuffer buf;
        if (capacity > buffSize) {
            throw new RuntimeException("Unsupported buffer size: " + capacity + ". Supported buffer sizes: " + buffSize + " or smaller.");
        }
        do {
            if ((sbuf = this.pool.pollFirst()) != null) continue;
            return ByteBuffer.allocate(buffSize);
        } while ((buf = sbuf.get()) == null);
        return buf;
    }

    @Override
    public synchronized void release(ByteBuffer buffer) {
        if (buffer.capacity() >= buffSize) {
            buffer.clear();
            this.pool.addFirst(new SoftReference<ByteBuffer>(buffer));
        }
    }
}

