/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

@BugPattern(name="NullablePrimitiveArray", summary="@Nullable type annotations should not be used for primitive types since they cannot be null", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
public class NullablePrimitiveArray
extends BugChecker
implements BugChecker.VariableTreeMatcher,
BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        return this.check(tree.getReturnType(), tree.getModifiers().getAnnotations(), state);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        return this.check(tree.getType(), tree.getModifiers().getAnnotations(), state);
    }

    private Description check(Tree typeTree, List<? extends AnnotationTree> annotations, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)typeTree);
        if (type == null) {
            return Description.NO_MATCH;
        }
        if (!type.getKind().equals((Object)TypeKind.ARRAY)) {
            return Description.NO_MATCH;
        }
        while (type.getKind().equals((Object)TypeKind.ARRAY)) {
            type = state.getTypes().elemtype(type);
        }
        if (!type.isPrimitive()) {
            return Description.NO_MATCH;
        }
        AnnotationTree annotation = ASTHelpers.getAnnotationWithSimpleName(annotations, (String)"Nullable");
        if (annotation == null) {
            return Description.NO_MATCH;
        }
        Attribute.Compound target = ASTHelpers.getSymbol((Tree)annotation).attribute(state.getSymtab().annotationTargetType.tsym);
        if (!NullablePrimitiveArray.isTypeAnnotation(target)) {
            return Description.NO_MATCH;
        }
        Tree dims = typeTree;
        while (dims instanceof ArrayTypeTree) {
            dims = ((ArrayTypeTree)dims).getType();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder().delete((Tree)annotation);
        if (!(dims instanceof AnnotatedTypeTree) || ASTHelpers.getAnnotationsWithSimpleName(((AnnotatedTypeTree)dims).getAnnotations(), (String)"Nullable") == null) {
            fix.postfixWith(dims, " " + state.getSourceForNode((Tree)annotation) + " ");
        }
        return this.describeMatch(annotation, (Fix)fix.build());
    }

    private static boolean isTypeAnnotation(Attribute.Compound attribute) {
        if (attribute == null) {
            return false;
        }
        final HashSet targets = new HashSet();
        Optional value = MoreAnnotations.getValue((Attribute.Compound)attribute, (String)"value");
        if (!value.isPresent()) {
            return false;
        }
        new SimpleAnnotationValueVisitor8<Void, Void>(){

            @Override
            public Void visitEnumConstant(VariableElement c, Void unused) {
                targets.add(c.getSimpleName().toString());
                return null;
            }

            @Override
            public Void visitArray(List<? extends AnnotationValue> list, Void unused) {
                list.forEach(x -> x.accept(this, null));
                return null;
            }
        }.visit((AnnotationValue)value.get(), null);
        Iterator iterator = targets.iterator();
        while (iterator.hasNext()) {
            String target;
            switch (target = (String)iterator.next()) {
                case "METHOD": 
                case "FIELD": 
                case "LOCAL_VARIABLE": 
                case "PARAMETER": {
                    return false;
                }
            }
        }
        return targets.contains("TYPE_USE");
    }
}

