/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Modifier;

@BugPattern(name="PrivateConstructorForUtilityClass", summary="Classes which are not intended to be instantiated should be made non-instantiable with a private constructor. This includes utility classes (classes with only static members), and the main class.", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class PrivateConstructorForUtilityClass
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree classTree, VisitorState state) {
        if (!classTree.getKind().equals((Object)Tree.Kind.CLASS) || classTree.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) || classTree.getExtendsClause() != null || !classTree.getImplementsClause().isEmpty() || PrivateConstructorForUtilityClass.isInPrivateScope(state) || ASTHelpers.hasAnnotation((Symbol)ASTHelpers.getSymbol((ClassTree)classTree), (String)"org.junit.runner.RunWith", (VisitorState)state) || ASTHelpers.hasAnnotation((Symbol)ASTHelpers.getSymbol((ClassTree)classTree), (String)"org.robolectric.annotation.Implements", (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        ImmutableList nonSyntheticMembers = (ImmutableList)classTree.getMembers().stream().filter(tree -> !tree.getKind().equals((Object)Tree.Kind.METHOD) || !ASTHelpers.isGeneratedConstructor((MethodTree)((MethodTree)tree))).collect(ImmutableList.toImmutableList());
        if (nonSyntheticMembers.isEmpty() || nonSyntheticMembers.stream().anyMatch(PrivateConstructorForUtilityClass::isInstance)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder().merge(SuggestedFixes.addMembers((ClassTree)classTree, (VisitorState)state, (String)ASTHelpers.createPrivateConstructor((ClassTree)classTree), (String[])new String[0]));
        SuggestedFixes.addModifiers((Tree)classTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL}).ifPresent(arg_0 -> ((SuggestedFix.Builder)fix).merge(arg_0));
        return this.describeMatch(classTree, (Fix)fix.build());
    }

    private static boolean isInPrivateScope(VisitorState state) {
        return Streams.stream((Iterable)state.getPath()).anyMatch(currentLeaf -> currentLeaf instanceof ClassTree && ((ClassTree)currentLeaf).getModifiers().getFlags().contains((Object)Modifier.PRIVATE));
    }

    private static boolean isInstance(Tree tree) {
        switch (tree.getKind()) {
            case CLASS: {
                return !((ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC);
            }
            case METHOD: {
                return !((MethodTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC);
            }
            case VARIABLE: {
                return !((VariableTree)tree).getModifiers().getFlags().contains((Object)Modifier.STATIC);
            }
            case BLOCK: {
                return !((BlockTree)tree).isStatic();
            }
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: {
                return false;
            }
        }
        if (tree.getKind().name().equals("RECORD")) {
            return false;
        }
        throw new AssertionError((Object)("unknown member type:" + (Object)((Object)tree.getKind())));
    }
}

