/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

@BugPattern(name="RequiredModifiers", summary="This annotation is missing required modifiers as specified by its @RequiredModifiers annotation", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.ERROR)
public class RequiredModifiersChecker
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final String MESSAGE_TEMPLATE = "%s has specified that it must be used together with the following modifiers: %s";
    private static final String REQUIRED_MODIFIERS = "com.google.errorprone.annotations.RequiredModifiers";

    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        Attribute.Compound annotation = sym.getRawAttributes().stream().filter(a -> a.type.tsym.getQualifiedName().contentEquals(REQUIRED_MODIFIERS)).findAny().orElse(null);
        if (annotation == null) {
            return Description.NO_MATCH;
        }
        LinkedHashSet requiredModifiers = new LinkedHashSet();
        MoreAnnotations.getValue((Attribute.Compound)annotation, (String)"value").ifPresent(a -> RequiredModifiersChecker.getModifiers(requiredModifiers, a));
        MoreAnnotations.getValue((Attribute.Compound)annotation, (String)"modifier").ifPresent(a -> RequiredModifiersChecker.getModifiers(requiredModifiers, a));
        if (requiredModifiers.isEmpty()) {
            return Description.NO_MATCH;
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof ModifiersTree)) {
            return Description.NO_MATCH;
        }
        Sets.SetView missing = Sets.difference(requiredModifiers, ((ModifiersTree)parent).getFlags());
        if (missing.isEmpty()) {
            return Description.NO_MATCH;
        }
        String annotationName = ASTHelpers.getAnnotationName((AnnotationTree)tree);
        String nameString = annotationName != null ? String.format("The annotation '@%s'", annotationName) : "This annotation";
        String customMessage = String.format(MESSAGE_TEMPLATE, nameString, missing);
        return this.buildDescription(tree).addFix(SuggestedFixes.addModifiers((Tree)state.getPath().getParentPath().getParentPath().getLeaf(), (ModifiersTree)((ModifiersTree)parent), (VisitorState)state, (Set)missing)).setMessage(customMessage).build();
    }

    private static void getModifiers(Collection<Modifier> modifiers, Attribute attribute) {
        class Visitor
        extends SimpleAnnotationValueVisitor8<Void, Void> {
            final /* synthetic */ Collection val$modifiers;

            Visitor(Collection collection) {
                this.val$modifiers = collection;
            }

            @Override
            public Void visitEnumConstant(VariableElement c, Void unused) {
                this.val$modifiers.add(Modifier.valueOf(c.getSimpleName().toString()));
                return null;
            }

            @Override
            public Void visitArray(List<? extends AnnotationValue> vals, Void unused) {
                vals.forEach(val -> val.accept(this, null));
                return null;
            }
        }
        attribute.accept(new Visitor(modifiers), null);
    }
}

