/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryArrowBatchWrapper;
import com.google.cloud.bigquery.jdbc.BigQueryArrowResultSet;
import com.google.cloud.bigquery.jdbc.BigQueryArrowStruct;
import com.google.cloud.bigquery.jdbc.BigQueryBaseArray;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryTypeCoercer;
import com.google.cloud.bigquery.jdbc.BigQueryTypeCoercionUtility;
import java.sql.ResultSet;
import java.sql.SQLException;
import shaded.bqjdbc.com.google.cloud.Tuple;
import shaded.bqjdbc.com.google.cloud.bigquery.Field;
import shaded.bqjdbc.com.google.cloud.bigquery.Schema;
import shaded.bqjdbc.org.apache.arrow.vector.util.JsonStringArrayList;
import shaded.bqjdbc.org.apache.arrow.vector.util.JsonStringHashMap;

class BigQueryArrowArray
extends BigQueryBaseArray {
    private static final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(BigQueryArrowArray.class.getName());
    private static final BigQueryTypeCoercer BIGQUERY_TYPE_COERCER = BigQueryTypeCoercionUtility.INSTANCE;
    private JsonStringArrayList<?> values;

    public BigQueryArrowArray(Field schema, JsonStringArrayList<?> values) {
        super(schema);
        this.values = values;
    }

    @Override
    public Object getArray() {
        LOG.finest("++enter++");
        this.ensureValid();
        if (this.values == null) {
            return null;
        }
        return this.getArrayInternal(0, this.values.size());
    }

    @Override
    public Object getArray(long index, int count) {
        LOG.finest("++enter++");
        this.ensureValid();
        if (this.values == null) {
            return null;
        }
        Tuple<Integer, Integer> range = this.createRange(index, count, this.values.size());
        return this.getArrayInternal(range.x(), range.y());
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        LOG.finest("++enter++");
        this.ensureValid();
        if (this.values == null) {
            return new BigQueryArrowResultSet();
        }
        BigQueryArrowBatchWrapper arrowBatchWrapper = BigQueryArrowBatchWrapper.getNestedFieldValueListWrapper(this.values, new boolean[0]);
        return BigQueryArrowResultSet.getNestedResultSet(Schema.of(this.singleElementSchema()), arrowBatchWrapper, 0, this.values.size());
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        LOG.finest("++enter++");
        this.ensureValid();
        if (this.values == null) {
            return new BigQueryArrowResultSet();
        }
        Tuple<Integer, Integer> range = this.createRange(index, count, this.values.size());
        BigQueryArrowBatchWrapper arrowBatchWrapper = BigQueryArrowBatchWrapper.getNestedFieldValueListWrapper(this.values, new boolean[0]);
        return BigQueryArrowResultSet.getNestedResultSet(Schema.of(this.singleElementSchema()), arrowBatchWrapper, range.x(), range.y());
    }

    @Override
    public void free() {
        LOG.finest("++enter++");
        this.values = null;
        this.markInvalid();
    }

    @Override
    Object getCoercedValue(int index) {
        LOG.finest("++enter++");
        Object value = this.values.get(index);
        return this.arrayOfStruct ? new BigQueryArrowStruct(this.schema.getSubFields(), (JsonStringHashMap)value) : BIGQUERY_TYPE_COERCER.coerceTo(this.getTargetClass(), value);
    }
}

