/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryArrowArray;
import com.google.cloud.bigquery.jdbc.BigQueryArrowBatchWrapper;
import com.google.cloud.bigquery.jdbc.BigQueryArrowStruct;
import com.google.cloud.bigquery.jdbc.BigQueryBaseArray;
import com.google.cloud.bigquery.jdbc.BigQueryBaseResultSet;
import com.google.cloud.bigquery.jdbc.BigQueryBaseStruct;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcTypeMappings;
import com.google.cloud.bigquery.jdbc.BigQueryStatement;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import shaded.bqjdbc.com.google.cloud.bigquery.BigQuery;
import shaded.bqjdbc.com.google.cloud.bigquery.Schema;
import shaded.bqjdbc.com.google.cloud.bigquery.StandardSQLTypeName;
import shaded.bqjdbc.com.google.cloud.bigquery.exception.BigQueryJdbcException;
import shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.ArrowSchema;
import shaded.bqjdbc.org.apache.arrow.memory.BufferAllocator;
import shaded.bqjdbc.org.apache.arrow.memory.RootAllocator;
import shaded.bqjdbc.org.apache.arrow.vector.FieldVector;
import shaded.bqjdbc.org.apache.arrow.vector.VectorLoader;
import shaded.bqjdbc.org.apache.arrow.vector.VectorSchemaRoot;
import shaded.bqjdbc.org.apache.arrow.vector.ipc.ReadChannel;
import shaded.bqjdbc.org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import shaded.bqjdbc.org.apache.arrow.vector.ipc.message.MessageSerializer;
import shaded.bqjdbc.org.apache.arrow.vector.types.pojo.Field;
import shaded.bqjdbc.org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;
import shaded.bqjdbc.org.apache.arrow.vector.util.JsonStringArrayList;
import shaded.bqjdbc.org.apache.arrow.vector.util.JsonStringHashMap;

class BigQueryArrowResultSet
extends BigQueryBaseResultSet {
    private final long totalRows;
    private long rowCount = 0L;
    private final BlockingQueue<BigQueryArrowBatchWrapper> buffer;
    private final BigQueryArrowBatchWrapper currentNestedBatch;
    private final int fromIndex;
    private final int toIndexExclusive;
    private int currentBatchRowIndex = -1;
    private boolean hasReachedEnd = false;
    private int nestedRowIndex;
    private boolean afterLast = false;
    private ArrowDeserializer arrowDeserializer;
    BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private VectorSchemaRoot vectorSchemaRoot;
    private VectorLoader vectorLoader;
    private final Thread ownedThread;

    private BigQueryArrowResultSet(Schema schema, ArrowSchema arrowSchema, long totalRows, BigQueryStatement statement, BlockingQueue<BigQueryArrowBatchWrapper> buffer, BigQueryArrowBatchWrapper currentNestedBatch, boolean isNested, int fromIndex, int toIndexExclusive, Thread ownedThread, BigQuery bigQuery) throws SQLException {
        super(bigQuery, statement, schema, isNested);
        this.LOG.finest("++enter++");
        this.totalRows = totalRows;
        this.buffer = buffer;
        this.currentNestedBatch = currentNestedBatch;
        this.fromIndex = fromIndex;
        this.toIndexExclusive = toIndexExclusive;
        this.nestedRowIndex = fromIndex - 1;
        this.ownedThread = ownedThread;
        if (!isNested && arrowSchema != null) {
            try {
                this.arrowDeserializer = new ArrowDeserializer(arrowSchema);
            }
            catch (IOException ex) {
                throw new BigQueryJdbcException(ex);
            }
        }
    }

    static BigQueryArrowResultSet of(Schema schema, ArrowSchema arrowSchema, long totalRows, BigQueryStatement statement, BlockingQueue<BigQueryArrowBatchWrapper> buffer, Thread ownedThread, BigQuery bigQuery) throws SQLException {
        return new BigQueryArrowResultSet(schema, arrowSchema, totalRows, statement, buffer, null, false, -1, -1, ownedThread, bigQuery);
    }

    BigQueryArrowResultSet() throws SQLException {
        super(null, null, null, false);
        this.totalRows = 0L;
        this.buffer = null;
        this.currentNestedBatch = null;
        this.fromIndex = 0;
        this.toIndexExclusive = 0;
        this.ownedThread = null;
        this.arrowDeserializer = null;
        this.vectorSchemaRoot = null;
        this.vectorLoader = null;
    }

    static BigQueryArrowResultSet getNestedResultSet(Schema schema, BigQueryArrowBatchWrapper nestedBatch, int fromIndex, int toIndexExclusive) throws SQLException {
        return new BigQueryArrowResultSet(schema, null, -1L, null, null, nestedBatch, true, fromIndex, toIndexExclusive, null, null);
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.isNested) {
            if (this.currentNestedBatch == null || this.currentNestedBatch.getNestedRecords() == null) {
                throw new IllegalStateException("currentNestedBatch/JsonStringArrayList can not be null working with the nested record");
            }
            if (this.nestedRowIndex < this.toIndexExclusive - 1) {
                ++this.nestedRowIndex;
                return true;
            }
            this.afterLast = true;
            return false;
        }
        if (this.hasReachedEnd || this.isLast()) {
            this.afterLast = true;
            return false;
        }
        try {
            if (this.currentBatchRowIndex == -1 || this.currentBatchRowIndex == this.vectorSchemaRoot.getRowCount() - 1) {
                BigQueryArrowBatchWrapper batchWrapper = this.buffer.take();
                if (batchWrapper.isLast()) {
                    if (this.vectorSchemaRoot != null) {
                        this.vectorSchemaRoot.clear();
                    }
                    this.hasReachedEnd = true;
                    ++this.rowCount;
                    return false;
                }
                shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.ArrowRecordBatch arrowBatch = batchWrapper.getCurrentArrowBatch();
                this.arrowDeserializer.deserializeArrowBatch(arrowBatch);
                this.currentBatchRowIndex = 0;
                ++this.rowCount;
                return true;
            }
            if (this.currentBatchRowIndex < this.vectorSchemaRoot.getRowCount()) {
                ++this.currentBatchRowIndex;
                ++this.rowCount;
                return true;
            }
        }
        catch (InterruptedException | SQLException ex) {
            throw new BigQueryJdbcException("Error occurred while advancing the cursor. This could happen when connection is closed while the next method is being called.", ex);
        }
        return false;
    }

    private Object getObjectInternal(int columnIndex) throws SQLException {
        Object value;
        this.LOG.finest("++enter++");
        this.checkClosed();
        if (this.isNested) {
            if (columnIndex != 1 && columnIndex != 2) {
                throw new IllegalArgumentException("Column index is required to be 1 or 2 for nested arrays");
            }
            if (this.currentNestedBatch.getNestedRecords() == null) {
                throw new IllegalStateException("JsonStringArrayList cannot be null for nested records.");
            }
            if (columnIndex == 1) {
                return this.nestedRowIndex + 1;
            }
            value = this.currentNestedBatch.getNestedRecords().get(this.nestedRowIndex);
        } else {
            FieldVector currentColumn = this.vectorSchemaRoot.getVector(columnIndex - 1);
            value = currentColumn.getObject(this.currentBatchRowIndex);
        }
        this.setWasNull(value);
        return value;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.LOG.finest("++enter++");
        this.checkClosed();
        Object value = this.getObjectInternal(columnIndex);
        if (value == null) {
            return null;
        }
        if (this.isNested && columnIndex == 1) {
            return this.bigQueryTypeCoercer.coerceTo(Integer.class, value);
        }
        if (this.isNested && columnIndex == 2) {
            shaded.bqjdbc.com.google.cloud.bigquery.Field arrayField = this.schema.getFields().get(0);
            if (BigQueryBaseStruct.isStruct(arrayField)) {
                return new BigQueryArrowStruct(arrayField.getSubFields(), (JsonStringHashMap)value);
            }
            Class<?> targetClass = BigQueryJdbcTypeMappings.standardSQLToJavaTypeMapping.get((Object)arrayField.getType().getStandardType());
            return this.bigQueryTypeCoercer.coerceTo(targetClass, value);
        }
        int fieldIndex = this.isNested ? 0 : columnIndex - 1;
        shaded.bqjdbc.com.google.cloud.bigquery.Field fieldSchema = this.schemaFieldList.get(fieldIndex);
        if (BigQueryBaseArray.isArray(fieldSchema)) {
            JsonStringArrayList originalList = (JsonStringArrayList)value;
            StandardSQLTypeName elementTypeName = fieldSchema.getType().getStandardType();
            if (elementTypeName == StandardSQLTypeName.NUMERIC || elementTypeName == StandardSQLTypeName.BIGNUMERIC) {
                JsonStringArrayList<BigDecimal> newList = new JsonStringArrayList<BigDecimal>();
                for (Object item : originalList) {
                    if (item != null) {
                        newList.add(((BigDecimal)item).stripTrailingZeros());
                        continue;
                    }
                    newList.add(null);
                }
                return new BigQueryArrowArray(fieldSchema, newList);
            }
            if (elementTypeName == StandardSQLTypeName.RANGE) {
                JsonStringArrayList<String> newList = new JsonStringArrayList<String>();
                for (Object item : originalList) {
                    if (item != null) {
                        JsonStringHashMap rangeMap = (JsonStringHashMap)item;
                        Object start = rangeMap.get("start");
                        Object end = rangeMap.get("end");
                        Object representativeElement = start != null ? start : end;
                        StandardSQLTypeName rangeElementType = this.getElementTypeFromValue(representativeElement);
                        String formattedStart = this.formatRangeElement(start, rangeElementType);
                        String formattedEnd = this.formatRangeElement(end, rangeElementType);
                        newList.add(String.format("[%s, %s)", formattedStart, formattedEnd));
                        continue;
                    }
                    newList.add(null);
                }
                return new BigQueryArrowArray(fieldSchema, newList);
            }
            return new BigQueryArrowArray(fieldSchema, originalList);
        }
        if (BigQueryBaseStruct.isStruct(fieldSchema)) {
            return new BigQueryArrowStruct(fieldSchema.getSubFields(), (JsonStringHashMap)value);
        }
        if (fieldSchema.getType().getStandardType() == StandardSQLTypeName.RANGE) {
            JsonStringHashMap rangeMap = (JsonStringHashMap)value;
            Object start = rangeMap.get("start");
            Object end = rangeMap.get("end");
            Object representativeElement = start != null ? start : end;
            StandardSQLTypeName elementType = this.getElementTypeFromValue(representativeElement);
            String formattedStart = this.formatRangeElement(start, elementType);
            String formattedEnd = this.formatRangeElement(end, elementType);
            return String.format("[%s, %s)", formattedStart, formattedEnd);
        }
        if ((fieldSchema.getType().getStandardType() == StandardSQLTypeName.NUMERIC || fieldSchema.getType().getStandardType() == StandardSQLTypeName.BIGNUMERIC) && value instanceof BigDecimal) {
            return ((BigDecimal)value).stripTrailingZeros();
        }
        Class<?> targetClass = BigQueryJdbcTypeMappings.standardSQLToJavaTypeMapping.get((Object)fieldSchema.getType().getStandardType());
        return this.bigQueryTypeCoercer.coerceTo(targetClass, value);
    }

    private StandardSQLTypeName getElementTypeFromValue(Object element) {
        if (element == null) {
            return StandardSQLTypeName.STRING;
        }
        if (element instanceof Integer) {
            return StandardSQLTypeName.DATE;
        }
        if (element instanceof Long) {
            return StandardSQLTypeName.TIMESTAMP;
        }
        if (element instanceof LocalDateTime) {
            return StandardSQLTypeName.DATETIME;
        }
        return StandardSQLTypeName.STRING;
    }

    private String formatRangeElement(Object element, StandardSQLTypeName elementType) {
        if (element == null) {
            return "UNBOUNDED";
        }
        switch (elementType) {
            case DATE: {
                Date date = this.bigQueryTypeCoercer.coerceTo(Date.class, (Integer)element);
                return date.toString();
            }
            case DATETIME: {
                Timestamp dtTs = this.bigQueryTypeCoercer.coerceTo(Timestamp.class, (LocalDateTime)element);
                return this.bigQueryTypeCoercer.coerceTo(String.class, dtTs);
            }
            case TIMESTAMP: {
                Timestamp ts = this.bigQueryTypeCoercer.coerceTo(Timestamp.class, (Long)element);
                return this.bigQueryTypeCoercer.coerceTo(String.class, ts);
            }
        }
        return element.toString();
    }

    @Override
    public void close() {
        this.LOG.fine(String.format("Closing BigqueryArrowResultSet %s.", this));
        this.isClosed = true;
        if (this.ownedThread != null && !this.ownedThread.isInterrupted()) {
            this.ownedThread.interrupt();
        }
        super.close();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.LOG.finest("++enter++");
        this.checkClosed();
        if (this.isNested) {
            return this.nestedRowIndex < this.fromIndex;
        }
        return this.rowCount == 0L;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.LOG.finest("++enter++");
        this.checkClosed();
        return this.afterLast;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.LOG.finest("++enter++");
        this.checkClosed();
        if (this.isNested) {
            return this.nestedRowIndex == this.fromIndex;
        }
        return this.rowCount == 1L;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.LOG.finest("++enter++");
        this.checkClosed();
        if (this.isNested) {
            return this.nestedRowIndex == this.toIndexExclusive - 1;
        }
        return this.rowCount == this.totalRows;
    }

    private class ArrowDeserializer
    implements AutoCloseable {
        private ArrowDeserializer(ArrowSchema arrowSchema) throws IOException {
            shaded.bqjdbc.org.apache.arrow.vector.types.pojo.Schema schema = MessageSerializer.deserializeSchema(new ReadChannel(new ByteArrayReadableSeekableByteChannel(arrowSchema.getSerializedSchema().toByteArray())));
            ArrayList<FieldVector> vectors = new ArrayList<FieldVector>();
            List<Field> fields = schema.getFields();
            for (Field field : fields) {
                vectors.add(field.createVector(BigQueryArrowResultSet.this.allocator));
            }
            BigQueryArrowResultSet.this.vectorSchemaRoot = new VectorSchemaRoot(vectors);
            BigQueryArrowResultSet.this.vectorLoader = new VectorLoader(BigQueryArrowResultSet.this.vectorSchemaRoot);
        }

        private void deserializeArrowBatch(shaded.bqjdbc.com.google.cloud.bigquery.storage.v1.ArrowRecordBatch batch) throws SQLException {
            BigQueryArrowResultSet.this.LOG.finest("++enter++");
            try {
                if (BigQueryArrowResultSet.this.vectorSchemaRoot != null) {
                    BigQueryArrowResultSet.this.vectorSchemaRoot.clear();
                }
                ArrowRecordBatch deserializedBatch = MessageSerializer.deserializeRecordBatch(new ReadChannel(new ByteArrayReadableSeekableByteChannel(batch.getSerializedRecordBatch().toByteArray())), BigQueryArrowResultSet.this.allocator);
                BigQueryArrowResultSet.this.vectorLoader.load(deserializedBatch);
                deserializedBatch.close();
            }
            catch (IOException | RuntimeException ex) {
                throw new BigQueryJdbcException(ex);
            }
        }

        @Override
        public void close() {
            BigQueryArrowResultSet.this.LOG.finest("++enter++");
            BigQueryArrowResultSet.this.vectorSchemaRoot.close();
            BigQueryArrowResultSet.this.allocator.close();
        }
    }
}

