/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryArrowArray;
import com.google.cloud.bigquery.jdbc.BigQueryBaseArray;
import com.google.cloud.bigquery.jdbc.BigQueryBaseStruct;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcTypeMappings;
import com.google.cloud.bigquery.jdbc.BigQueryTypeCoercer;
import com.google.cloud.bigquery.jdbc.BigQueryTypeCoercionUtility;
import java.lang.reflect.Array;
import java.util.ArrayList;
import shaded.bqjdbc.com.google.cloud.bigquery.Field;
import shaded.bqjdbc.com.google.cloud.bigquery.FieldList;
import shaded.bqjdbc.org.apache.arrow.vector.util.JsonStringArrayList;
import shaded.bqjdbc.org.apache.arrow.vector.util.JsonStringHashMap;

class BigQueryArrowStruct
extends BigQueryBaseStruct {
    private static final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(BigQueryArrowStruct.class.getName());
    private static final BigQueryTypeCoercer BIGQUERY_TYPE_COERCER = BigQueryTypeCoercionUtility.INSTANCE;
    private final FieldList schema;
    private final JsonStringHashMap<?, ?> values;

    BigQueryArrowStruct(FieldList schema, JsonStringHashMap<?, ?> values) {
        this.schema = schema;
        this.values = values;
    }

    @Override
    FieldList getSchema() {
        return this.schema;
    }

    @Override
    public Object[] getAttributes() {
        LOG.finest("++enter++");
        int size = this.schema.size();
        Object[] attributes = (Object[])Array.newInstance(Object.class, size);
        if (this.values == null) {
            return attributes;
        }
        ArrayList structValues = new ArrayList(this.values.values());
        for (int index = 0; index < size; ++index) {
            Field currentSchema = this.schema.get(index);
            Object currentValue = structValues.get(index);
            Object coercedValue = this.getValue(currentSchema, currentValue);
            Array.set(attributes, index, coercedValue);
        }
        return attributes;
    }

    private Object getValue(Field currentSchema, Object currentValue) {
        LOG.finest("++enter++");
        if (BigQueryBaseArray.isArray(currentSchema)) {
            return new BigQueryArrowArray(currentSchema, (JsonStringArrayList)currentValue);
        }
        if (BigQueryArrowStruct.isStruct(currentSchema)) {
            return new BigQueryArrowStruct(currentSchema.getSubFields(), (JsonStringHashMap)currentValue);
        }
        Class<?> targetClass = BigQueryJdbcTypeMappings.standardSQLToJavaTypeMapping.get((Object)currentSchema.getType().getStandardType());
        return BIGQUERY_TYPE_COERCER.coerceTo(targetClass, currentValue);
    }
}

