/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryBaseStruct;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcTypeMappings;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.stream.Collectors;
import shaded.bqjdbc.com.google.cloud.Tuple;
import shaded.bqjdbc.com.google.cloud.bigquery.Field;
import shaded.bqjdbc.com.google.cloud.bigquery.StandardSQLTypeName;
import shaded.bqjdbc.com.google.cloud.bigquery.exception.BigQueryJdbcSqlFeatureNotSupportedException;

abstract class BigQueryBaseArray
implements java.sql.Array {
    private static final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(BigQueryBaseArray.class.getName());
    protected final boolean arrayOfStruct;
    private boolean valid;
    protected Field schema;

    BigQueryBaseArray(Field schema) {
        this.schema = schema;
        this.arrayOfStruct = BigQueryBaseStruct.isStruct(schema);
        this.valid = true;
    }

    @Override
    public final String getBaseTypeName() {
        LOG.finest("++enter++");
        this.ensureValid();
        return this.schema.getType().getStandardType().name();
    }

    @Override
    public final int getBaseType() {
        LOG.finest("++enter++");
        this.ensureValid();
        return BigQueryJdbcTypeMappings.standardSQLToJavaSqlTypesMapping.get((Object)this.schema.getType().getStandardType());
    }

    @Override
    public final Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new BigQueryJdbcSqlFeatureNotSupportedException("Customized Types are not supported yet.");
    }

    @Override
    public final Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new BigQueryJdbcSqlFeatureNotSupportedException("Customized Types are not supported yet.");
    }

    @Override
    public final ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new BigQueryJdbcSqlFeatureNotSupportedException("Customized Types are not supported yet.");
    }

    @Override
    public final ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new BigQueryJdbcSqlFeatureNotSupportedException("Customized Types are not supported yet.");
    }

    protected Object getArrayInternal(int fromIndex, int toIndexExclusive) {
        LOG.finest("++enter++");
        Class<?> targetClass = this.getTargetClass();
        int size = toIndexExclusive - fromIndex;
        Object javaArray = Array.newInstance(targetClass, size);
        for (int index = 0; index < size; ++index) {
            Array.set(javaArray, index, this.getCoercedValue(fromIndex + index));
        }
        return javaArray;
    }

    protected void ensureValid() throws IllegalStateException {
        LOG.finest("++enter++");
        if (!this.valid) {
            throw new IllegalStateException("Invalid java.sql.Array instance.");
        }
    }

    protected void markInvalid() {
        LOG.finest("++enter++");
        this.schema = null;
        this.valid = false;
    }

    protected Field singleElementSchema() {
        LOG.finest("++enter++");
        return this.schema.toBuilder().setMode(Field.Mode.REQUIRED).build();
    }

    protected Tuple<Integer, Integer> createRange(long index, int count, int size) throws IllegalStateException {
        LOG.finest("++enter++");
        long normalisedFromIndex = index - 1L;
        if (normalisedFromIndex + (long)count > (long)size) {
            throw new IllegalArgumentException(String.format("The array index is out of range: %d, number of elements: %d.", index + (long)count, size));
        }
        long toIndex = normalisedFromIndex + (long)count;
        return Tuple.of((int)normalisedFromIndex, (int)toIndex);
    }

    protected Class<?> getTargetClass() {
        LOG.finest("++enter++");
        return this.arrayOfStruct ? Struct.class : BigQueryJdbcTypeMappings.standardSQLToJavaTypeMapping.get((Object)this.schema.getType().getStandardType());
    }

    abstract Object getCoercedValue(int var1);

    static boolean isArray(Field currentSchema) {
        LOG.finest("++enter++");
        return currentSchema.getMode() == Field.Mode.REPEATED;
    }

    public String toString() {
        try {
            Object[] array = (Object[])this.getArray();
            if (array == null) {
                return "null";
            }
            if (this.schema.getType().getStandardType() == StandardSQLTypeName.BYTES) {
                return Arrays.stream(array).map(element -> element == null ? "null" : Base64.getEncoder().encodeToString((byte[])element)).collect(Collectors.joining(", ", "[", "]"));
            }
            return Arrays.deepToString(array);
        }
        catch (SQLException e) {
            return "[Error converting array to string: " + e.getMessage() + "]";
        }
    }
}

