/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.jdbc;

import com.google.cloud.bigquery.jdbc.BigQueryArrowResultSet;
import com.google.cloud.bigquery.jdbc.BigQueryJdbcCustomLogger;
import com.google.cloud.bigquery.jdbc.BigQueryJsonResultSet;
import com.google.cloud.bigquery.jdbc.BigQueryResultSetFinalizers;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.List;
import shaded.bqjdbc.com.google.api.core.InternalApi;
import shaded.bqjdbc.com.google.cloud.bigquery.exception.BigQueryJdbcRuntimeException;

@InternalApi
class BigQueryDaemonPollingTask
extends Thread {
    private static final BigQueryJdbcCustomLogger LOG = new BigQueryJdbcCustomLogger(BigQueryDaemonPollingTask.class.getName());
    static ReferenceQueue<BigQueryArrowResultSet> referenceQueueArrowRs;
    static ReferenceQueue<BigQueryJsonResultSet> referenceQueueJsonRs;
    static List<BigQueryResultSetFinalizers.ArrowResultSetFinalizer> arrowRsFinalizers;
    static List<BigQueryResultSetFinalizers.JsonResultSetFinalizer> jsonRsFinalizers;
    private static BigQueryDaemonPollingTask arrowDaemon;
    private static BigQueryDaemonPollingTask jsonDaemon;
    private static final Object LOCK;

    private BigQueryDaemonPollingTask(List<BigQueryResultSetFinalizers.ArrowResultSetFinalizer> arrowRsFinalizers, ReferenceQueue<BigQueryArrowResultSet> referenceQueueArrowRs) {
        BigQueryDaemonPollingTask.referenceQueueArrowRs = referenceQueueArrowRs;
        BigQueryDaemonPollingTask.arrowRsFinalizers = arrowRsFinalizers;
        this.setDaemon(true);
    }

    private BigQueryDaemonPollingTask(ReferenceQueue<BigQueryJsonResultSet> referenceQueueJsonRs, List<BigQueryResultSetFinalizers.JsonResultSetFinalizer> jsonRsFinalizers) {
        BigQueryDaemonPollingTask.referenceQueueJsonRs = referenceQueueJsonRs;
        BigQueryDaemonPollingTask.jsonRsFinalizers = jsonRsFinalizers;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean startGcDaemonTask(ReferenceQueue<BigQueryArrowResultSet> referenceQueueArrowRs, ReferenceQueue<BigQueryJsonResultSet> referenceQueueJsonRs, List<BigQueryResultSetFinalizers.ArrowResultSetFinalizer> arrowRsFinalizers, List<BigQueryResultSetFinalizers.JsonResultSetFinalizer> jsonRsFinalizers) {
        LOG.finest("++enter++");
        Object object = LOCK;
        synchronized (object) {
            if (arrowDaemon == null && jsonDaemon == null) {
                arrowDaemon = new BigQueryDaemonPollingTask(arrowRsFinalizers, referenceQueueArrowRs);
                arrowDaemon.start();
                jsonDaemon = new BigQueryDaemonPollingTask(referenceQueueJsonRs, jsonRsFinalizers);
                jsonDaemon.start();
                return true;
            }
        }
        return false;
    }

    @Override
    public void run() {
        block6: {
            try {
                LOG.finest("++enter++");
                if (referenceQueueArrowRs != null) {
                    Reference<BigQueryArrowResultSet> reference;
                    while ((reference = referenceQueueArrowRs.remove()) != null) {
                        LOG.fine("Clearing Arrow ResultSet reference " + referenceQueueArrowRs);
                        ((BigQueryResultSetFinalizers.ArrowResultSetFinalizer)reference).finalizeResources();
                        reference.clear();
                    }
                    break block6;
                }
                if (referenceQueueJsonRs != null) {
                    Reference<BigQueryJsonResultSet> reference;
                    while ((reference = referenceQueueJsonRs.remove()) != null) {
                        LOG.fine("Clearing Json ResultSet reference " + referenceQueueJsonRs);
                        ((BigQueryResultSetFinalizers.JsonResultSetFinalizer)reference).finalizeResources();
                        reference.clear();
                    }
                    break block6;
                }
                throw new BigQueryJdbcRuntimeException("Null Reference Queue");
            }
            catch (InterruptedException ex) {
                throw new BigQueryJdbcRuntimeException(ex);
            }
        }
    }

    static {
        LOCK = new Object();
    }
}

